% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-functions-minor.R
\name{natural2parameters}
\alias{natural2parameters}
\title{Convert natural parameters to distribution parameters}
\usage{
natural2parameters(eta, ...)
}
\arguments{
\item{eta}{vector of natural parameters}

\item{...}{other arguments passed to methods}
}
\value{
A vector of the original distribution parameters
}
\description{
Convert natural parameters to distribution parameters
}
\examples{
samp <- rtrunc(n = 100, lambda = 2, family = "Poisson")
lambda_hat <- empiricalParameters(samp)
eta_hat <- parameters2natural(lambda_hat)
natural2parameters(eta_hat)  # yields back lambda
}
\seealso{
\code{\link[=parameters2natural]{parameters2natural()}}
}
