% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/competing_risks_methods.R
\name{cumhaz2ts}
\alias{cumhaz2ts}
\title{Cumulative hazard over two time scales}
\usage{
cumhaz2ts(
  fitted_model,
  plot_grid = NULL,
  cause = NULL,
  midpoints = FALSE,
  where_slices = NULL,
  direction = c("u", "s", NULL),
  tmax = NULL
)
}
\arguments{
\item{fitted_model}{(optional) The output of the function \code{fit2ts}.
This is an object of class \code{'haz2ts'} or \code{'haz2tsLMM'}.}

\item{plot_grid}{(optional) A list containing the parameters to build a new
finer grid of intervals over \code{u} and \code{s} for plotting. This must be of the
form:
\itemize{
\item \code{plot_grid = list(c(umin, umax, du), c(smin, smax, ds))}
where \code{umin}, \code{umax} and \code{smin}, \code{smax} are the minimum and maximum values
desired for the grid-points over \code{u} and \code{s} respectively, and \code{du}, \code{ds} are
distances between two adjacent points over \code{u} and \code{s} respectively.
Specifying a new denser grid is used to evaluate the B-spline bases used for
estimation on such grid and plot the estimated surfaces with a greater level
of detail.
If not specified, the plotting is done using the same B-splines bases as
for the estimation. The function will check if the parameters for the grid
provided by the user are compatible with those originally used to construct
the B-splines for estimating the model. If not, the grid will be adjusted
accordingly and a warning will be returned.
}}

\item{cause}{a character string with a short name for the cause (optional).}

\item{midpoints}{A Boolean. Default is \code{FALSE}. If \code{TRUE}, the estimated
quantities are evaluated at the midpoints of the rectangles
(or parallelograms) of the grids, rather than at each grid-point.}

\item{where_slices}{A vector of values for the cutting points of the desired
slices of the surface. This option is included mostly for the plotting function.
When using \code{plot.haz2ts()}, the user selects \code{which_plot = "cumhaz"} and
\code{cumhaz_slices = TRUE}, then \code{where_slices} indicates the location of the
cutting points over the \code{u} time.}

\item{direction}{If cross-sectional one-dimensional curves are plotted, this
indicates whether the cutting points are located on the \code{u} time, or on the
\code{s} time. For plots of the cumulative hazards, only cutting points over the
\code{u} time are meaningful.}

\item{tmax}{The maximum value of \code{t} that should be plotted.}
}
\value{
A list with the following elements:
* \code{Haz} a list of estimated hazard and associated SEs
(obtained from the function \code{get_hazard_2d});
* \code{CumHaz} the cumulated hazard estimate over \code{u} and \code{s};
* \code{cause} (if provided) the short name for the cause.
}
\description{
Computes the cumulative hazard surface over two time scales
from a fitted model. The function is also called internally from \code{plot()}
if the user wants to plot the cumulative hazard from a fitted model.
}
\examples{
# Create some fake data - the bare minimum
id <- 1:20
u <- c(5.43, 3.25, 8.15, 5.53, 7.28, 6.61, 5.91, 4.94, 4.25, 3.86, 4.05, 6.86,
       4.94, 4.46, 2.14, 7.56, 5.55, 7.60, 6.46, 4.96)
s <- c(0.44, 4.89, 0.92, 1.81, 2.02, 1.55, 3.16, 6.36, 0.66, 2.02, 1.22, 3.96,
       7.07, 2.91, 3.38, 2.36, 1.74, 0.06, 5.76, 3.00)
ev <- c(1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1)#'

fakedata <- as.data.frame(cbind(id, u, s, ev))
fakedata2ts <- prepare_data(u = fakedata$u,
                            s_out = fakedata$s,
                            ev = fakedata$ev,
                            ds = .5)
# Fit a fake model - not optimal smoothing
fakemod <- fit2ts(fakedata2ts,
                  optim_method = "grid_search",
                  lrho = list(seq(1 ,1.5 ,.5),
                              seq(1 ,1.5 ,.5)))

# Obtain the fake cumulated hazard
fakecumhaz2ts <- cumhaz2ts(fakemod)

}
