#' @family pooled estimates (two-sample)
#' @inherit uM6pool title description params
#' @return Pooled estimate of cubed variance  central moment
#'   \eqn{\mu_2^3}{\mu[2]^3}, where \eqn{\mu_2}{\mu[2]} is a variance.
#' @examples
#' nx <- 10
#' ny <- 8
#' shp <- 3
#' smpx <- rgamma(nx, shape = shp) - shp
#' smpy <- rgamma(ny, shape = shp)
#' mx <- mean(smpx)
#' my <- mean(smpy)
#' m  <- numeric(6)
#' for (j in 2:6) {
#'   m[j] <- mean(c((smpx - mx)^j, (smpy - my)^j))
#' }
#' uM2pow3pool(m[2], m[3], m[4], m[6], nx, ny)
#' @export
uM2pow3pool <- function(m2, m3, m4, m6, n_x, n_y) {
    (m2^3*n_x^7*n_y^15 + 60*m2^3*n_x^12 + (8*m2^3*n_x^8 + 25*m2^3*n_x^6 - 23*m2^3*n_x^5 - 3*(12*m2^3 + m2*m4)*n_x^7 + 15*m2^3*n_x^4 - 5*m2^3*n_x^3)*n_y^14 - 780*m2^3*n_x^11 + (28*m2^3*n_x^9 - 21*(12*m2^3 + m2*m4)*n_x^8 + (709*m2^3 - 6*m3^2 + 96*m2*m4 + 2*m6)*n_x^7 - 6*(141*m2^3 + 10*m2*m4)*n_x^6 + 4*(197*m2^3 + 15*m2*m4)*n_x^5 - 95*m2^3*n_x^2 - 3*(149*m2^3 + 15*m2*m4)*n_x^4 + 15*m2^3*n_x + 5*(41*m2^3 + 3*m2*m4)*n_x^3)*n_y^13 + 840*m2^3*n_x^10 + (56*m2^3*n_x^10 - 63*(12*m2^3 + m2*m4)*n_x^9 + 2*(1877*m2^3 - 18*m3^2 + 288*m2*m4 + 6*m6)*n_x^8 - 3*(2909*m2^3 - 58*m3^2 + 537*m2*m4 + 18*m6)*n_x^7 + (11955*m2^3 - 160*m3^2 + 1713*m2*m4 + 32*m6)*n_x^6 - (11816*m2^3 - 130*m3^2 + 1581*m2*m4 + 23*m6)*n_x^5 + (7877*m2^3 + 40*m3^2 + 900*m2*m4 + 9*m6)*n_x^4 - 360*m2^3*n_x - (3879*m2^3 + 70*m3^2 + 300*m2*m4)*n_x^3 + 60*m2^3 + 5*(299*m2^3 + 15*m2*m4)*n_x^2)*n_y^12 - 120*m2^3*n_x^9 + (70*m2^3*n_x^11 - 105*(12*m2^3 + m2*m4)*n_x^10 + 5*(1807*m2^3 - 18*m3^2 + 288*m2*m4 + 6*m6)*n_x^9 - 3*(10827*m2^3 - 290*m3^2 + 2405*m2*m4 + 90*m6)*n_x^8 + 4*(16511*m2^3 - 639*m3^2 + 4047*m2*m4 + 181*m6)*n_x^7 - (89196*m2^3 - 3304*m3^2 + 19755*m2*m4 + 653*m6)*n_x^6 + (87541*m2^3 - 3246*m3^2 + 18108*m2*m4 + 450*m6)*n_x^5 - (63299*m2^3 - 1682*m3^2 + 10749*m2*m4 + 205*m6)*n_x^4 + (36122*m2^3 - 760*m3^2 + 4125*m2*m4 + 42*m6)*n_x^3 - 780*m2^3 - 10*(1645*m2^3 - 45*m3^2 + 108*m2*m4)*n_x^2 + 15*(341*m2^3 - 4*m3^2 + 4*m2*m4)*n_x)*n_y^11 + (56*m2^3*n_x^12 - 105*(12*m2^3 + m2*m4)*n_x^11 + 10*(1193*m2^3 - 12*m3^2 + 192*m2*m4 + 4*m6)*n_x^10 - 3*(19841*m2^3 - 580*m3^2 + 4670*m2*m4 + 180*m6)*n_x^9 + (168814*m2^3 - 8784*m3^2 + 50295*m2*m4 + 2608*m6)*n_x^8 - 3*(99121*m2^3 - 6556*m3^2 + 31961*m2*m4 + 1805*m6)*n_x^7 + 2*(181130*m2^3 - 12302*m3^2 + 56625*m2*m4 + 2657*m6)*n_x^6 - (318147*m2^3 - 21018*m3^2 + 95292*m2*m4 + 3428*m6)*n_x^5 + (202967*m2^3 - 10396*m3^2 + 53022*m2*m4 + 1361*m6)*n_x^4 - (96013*m2^3 - 4030*m3^2 + 19785*m2*m4 + 216*m6)*n_x^3 + 840*m2^3 + (33500*m2^3 - 1950*m3^2 + 5475*m2*m4 - 24*m6)*n_x^2 - 30*(259*m2^3 - 14*m3^2 + 26*m2*m4)*n_x)*n_y^10 + (28*m2^3*n_x^13 - 63*(12*m2^3 + m2*m4)*n_x^12 + 5*(1807*m2^3 - 18*m3^2 + 288*m2*m4 + 6*m6)*n_x^11 - 3*(19841*m2^3 - 580*m3^2 + 4670*m2*m4 + 180*m6)*n_x^10 + 8*(28488*m2^3 - 1597*m3^2 + 8940*m2*m4 + 479*m6)*n_x^9 - (524853*m2^3 - 43394*m3^2 + 199536*m2*m4 + 13141*m6)*n_x^8 + (782078*m2^3 - 75330*m3^2 + 318525*m2*m4 + 22678*m6)*n_x^7 - 2*(404607*m2^3 - 39421*m3^2 + 163905*m2*m4 + 10687*m6)*n_x^6 + (587293*m2^3 - 53316*m3^2 + 231600*m2*m4 + 12780*m6)*n_x^5 - (292945*m2^3 - 20094*m3^2 + 105258*m2*m4 + 4637*m6)*n_x^4 + (98100*m2^3 - 5060*m3^2 + 30045*m2*m4 + 738*m6)*n_x^3 - 120*m2^3 - 6*(3595*m2^3 - 330*m3^2 + 1025*m2*m4 - 4*m6)*n_x^2 + 120*(24*m2^3 - 4*m3^2 + 7*m2*m4)*n_x)*n_y^9 + (8*m2^3*n_x^14 - 21*(12*m2^3 + m2*m4)*n_x^13 + 2*(1877*m2^3 - 18*m3^2 + 288*m2*m4 + 6*m6)*n_x^12 - 3*(10827*m2^3 - 290*m3^2 + 2405*m2*m4 + 90*m6)*n_x^11 + (168814*m2^3 - 8784*m3^2 + 50295*m2*m4 + 2608*m6)*n_x^10 - (524853*m2^3 - 43394*m3^2 + 199536*m2*m4 + 13141*m6)*n_x^9 + 2*(499687*m2^3 - 54012*m3^2 + 222498*m2*m4 + 17805*m6)*n_x^8 - (1246134*m2^3 - 143840*m3^2 + 579513*m2*m4 + 51873*m6)*n_x^7 + (1063586*m2^3 - 117460*m3^2 + 487407*m2*m4 + 43503*m6)*n_x^6 - (608283*m2^3 - 57142*m3^2 + 269208*m2*m4 + 22477*m6)*n_x^5 + 2*(107245*m2^3 - 5840*m3^2 + 43935*m2*m4 + 3332*m6)*n_x^4 - 6*(6475*m2^3 - 10*m3^2 + 2410*m2*m4 + 122*m6)*n_x^3 + 24*(85*m2^3 - 10*m3^2 + 50*m2*m4 - 2*m6)*n_x^2 + 120*(m2^3 + m3^2 - m2*m4)*n_x)*n_y^8 + (m2^3*n_x^15 - 3*(12*m2^3 + m2*m4)*n_x^14 + (709*m2^3 - 6*m3^2 + 96*m2*m4 + 2*m6)*n_x^13 - 3*(2909*m2^3 - 58*m3^2 + 537*m2*m4 + 18*m6)*n_x^12 + 4*(16511*m2^3 - 639*m3^2 + 4047*m2*m4 + 181*m6)*n_x^11 - 3*(99121*m2^3 - 6556*m3^2 + 31961*m2*m4 + 1805*m6)*n_x^10 + (782078*m2^3 - 75330*m3^2 + 318525*m2*m4 + 22678*m6)*n_x^9 - (1246134*m2^3 - 143840*m3^2 + 579513*m2*m4 + 51873*m6)*n_x^8 + 2*(644618*m2^3 - 73780*m3^2 + 304779*m2*m4 + 32042*m6)*n_x^7 - (888125*m2^3 - 95116*m3^2 + 410109*m2*m4 + 45758*m6)*n_x^6 + (385345*m2^3 - 34480*m3^2 + 172575*m2*m4 + 19414*m6)*n_x^5 - 6*(14465*m2^3 - 390*m3^2 + 5950*m2*m4 + 716*m6)*n_x^4 + 24*(160*m2^3 + 75*m3^2 + 25*m2*m4 + 7*m6)*n_x^3 + 24*(45*m2^3 - 10*m3^2 + 20*m2*m4 + 2*m6)*n_x^2)*n_y^7 + (25*m2^3*n_x^14 - 6*(141*m2^3 + 10*m2*m4)*n_x^13 + (11955*m2^3 - 160*m3^2 + 1713*m2*m4 + 32*m6)*n_x^12 - (89196*m2^3 - 3304*m3^2 + 19755*m2*m4 + 653*m6)*n_x^11 + 2*(181130*m2^3 - 12302*m3^2 + 56625*m2*m4 + 2657*m6)*n_x^10 - 2*(404607*m2^3 - 39421*m3^2 + 163905*m2*m4 + 10687*m6)*n_x^9 + (1063586*m2^3 - 117460*m3^2 + 487407*m2*m4 + 43503*m6)*n_x^8 - (888125*m2^3 - 95116*m3^2 + 410109*m2*m4 + 45758*m6)*n_x^7 + 2*(240510*m2^3 - 25970*m3^2 + 109335*m2*m4 + 13512*m6)*n_x^6 - 30*(5192*m2^3 - 560*m3^2 + 2361*m2*m4 + 302*m6)*n_x^5 + 48*(460*m2^3 - 25*m3^2 + 195*m2*m4 + 29*m6)*n_x^4 + 120*(m2^3 - 4*m3^2 + 4*m2*m4)*n_x^3)*n_y^6 - (23*m2^3*n_x^14 - 4*(197*m2^3 + 15*m2*m4)*n_x^13 + (11816*m2^3 - 130*m3^2 + 1581*m2*m4 + 23*m6)*n_x^12 - (87541*m2^3 - 3246*m3^2 + 18108*m2*m4 + 450*m6)*n_x^11 + (318147*m2^3 - 21018*m3^2 + 95292*m2*m4 + 3428*m6)*n_x^10 - (587293*m2^3 - 53316*m3^2 + 231600*m2*m4 + 12780*m6)*n_x^9 + (608283*m2^3 - 57142*m3^2 + 269208*m2*m4 + 22477*m6)*n_x^8 - (385345*m2^3 - 34480*m3^2 + 172575*m2*m4 + 19414*m6)*n_x^7 + 30*(5192*m2^3 - 560*m3^2 + 2361*m2*m4 + 302*m6)*n_x^6 - 48*(760*m2^3 - 115*m3^2 + 380*m2*m4 + 49*m6)*n_x^5 + 120*(26*m2^3 - 5*m3^2 + 15*m2*m4 + 2*m6)*n_x^4)*n_y^5 + (15*m2^3*n_x^14 - 3*(149*m2^3 + 15*m2*m4)*n_x^13 + (7877*m2^3 + 40*m3^2 + 900*m2*m4 + 9*m6)*n_x^12 - (63299*m2^3 - 1682*m3^2 + 10749*m2*m4 + 205*m6)*n_x^11 + (202967*m2^3 - 10396*m3^2 + 53022*m2*m4 + 1361*m6)*n_x^10 - (292945*m2^3 - 20094*m3^2 + 105258*m2*m4 + 4637*m6)*n_x^9 + 2*(107245*m2^3 - 5840*m3^2 + 43935*m2*m4 + 3332*m6)*n_x^8 - 6*(14465*m2^3 - 390*m3^2 + 5950*m2*m4 + 716*m6)*n_x^7 + 48*(460*m2^3 - 25*m3^2 + 195*m2*m4 + 29*m6)*n_x^6 - 120*(26*m2^3 - 5*m3^2 + 15*m2*m4 + 2*m6)*n_x^5)*n_y^4 - (5*m2^3*n_x^14 - 5*(41*m2^3 + 3*m2*m4)*n_x^13 + (3879*m2^3 + 70*m3^2 + 300*m2*m4)*n_x^12 - (36122*m2^3 - 760*m3^2 + 4125*m2*m4 + 42*m6)*n_x^11 + (96013*m2^3 - 4030*m3^2 + 19785*m2*m4 + 216*m6)*n_x^10 - (98100*m2^3 - 5060*m3^2 + 30045*m2*m4 + 738*m6)*n_x^9 + 6*(6475*m2^3 - 10*m3^2 + 2410*m2*m4 + 122*m6)*n_x^8 - 24*(160*m2^3 + 75*m3^2 + 25*m2*m4 + 7*m6)*n_x^7 - 120*(m2^3 - 4*m3^2 + 4*m2*m4)*n_x^6)*n_y^3 - (95*m2^3*n_x^13 - 5*(299*m2^3 + 15*m2*m4)*n_x^12 + 10*(1645*m2^3 - 45*m3^2 + 108*m2*m4)*n_x^11 - (33500*m2^3 - 1950*m3^2 + 5475*m2*m4 - 24*m6)*n_x^10 + 6*(3595*m2^3 - 330*m3^2 + 1025*m2*m4 - 4*m6)*n_x^9 - 24*(85*m2^3 - 10*m3^2 + 50*m2*m4 - 2*m6)*n_x^8 - 24*(45*m2^3 - 10*m3^2 + 20*m2*m4 + 2*m6)*n_x^7)*n_y^2 + 15*(m2^3*n_x^13 - 24*m2^3*n_x^12 + (341*m2^3 - 4*m3^2 + 4*m2*m4)*n_x^11 - 2*(259*m2^3 - 14*m3^2 + 26*m2*m4)*n_x^10 + 8*(24*m2^3 - 4*m3^2 + 7*m2*m4)*n_x^9 + 8*(m2^3 + m3^2 - m2*m4)*n_x^8)*n_y)/(n_x^7*n_y^15 + (8*n_x^8 - 45*n_x^7 + 25*n_x^6 - 23*n_x^5 + 15*n_x^4 - 5*n_x^3)*n_y^14 + (28*n_x^9 - 315*n_x^8 + 1041*n_x^7 - 1035*n_x^6 + 968*n_x^5 - 582*n_x^4 + 250*n_x^3 - 95*n_x^2 + 15*n_x)*n_y^13 + (56*n_x^10 - 945*n_x^9 + 5746*n_x^8 - 15009*n_x^7 + 18194*n_x^6 - 17382*n_x^5 + 11102*n_x^4 - 4984*n_x^3 + 1765*n_x^2 - 360*n_x + 60)*n_y^12 + 60*n_x^12 + (70*n_x^11 - 1575*n_x^10 + 14015*n_x^9 - 61245*n_x^8 + 138114*n_x^7 - 174283*n_x^6 + 163238*n_x^5 - 107571*n_x^4 + 52507*n_x^3 - 20705*n_x^2 + 5460*n_x - 780)*n_y^11 - 780*n_x^11 + (56*n_x^12 - 1575*n_x^11 + 18570*n_x^10 - 115728*n_x^9 + 403823*n_x^8 - 803772*n_x^7 + 969776*n_x^6 - 834367*n_x^5 + 498284*n_x^4 - 209069*n_x^3 + 65785*n_x^2 - 12810*n_x + 780)*n_y^10 + 780*n_x^10 + (28*n_x^13 - 945*n_x^12 + 14015*n_x^11 - 115728*n_x^10 + 565900*n_x^9 - 1656392*n_x^8 + 2913840*n_x^7 - 3198552*n_x^6 + 2405947*n_x^5 - 1196804*n_x^4 + 378693*n_x^3 - 82370*n_x^2 + 10845*n_x + 660)*n_y^9 + 660*n_x^9 + (8*n_x^14 - 315*n_x^13 + 5746*n_x^12 - 61245*n_x^11 + 403823*n_x^10 - 1656392*n_x^9 + 4192900*n_x^8 - 6526559*n_x^7 + 6365599*n_x^6 - 4065108*n_x^5 + 1560742*n_x^4 - 280282*n_x^3 + 8290*n_x^2 + 1290*n_x - 840)*n_y^8 - 840*n_x^8 + (n_x^15 - 45*n_x^14 + 1041*n_x^13 - 15009*n_x^12 + 138114*n_x^11 - 803772*n_x^10 + 2913840*n_x^9 - 6526559*n_x^8 + 9021718*n_x^7 - 7773202*n_x^6 + 4204679*n_x^5 - 1200142*n_x^4 + 38980*n_x^3 + 54690*n_x^2 - 6960*n_x + 120)*n_y^7 + 120*n_x^7 + (25*n_x^14 - 1035*n_x^13 + 18194*n_x^12 - 174283*n_x^11 + 969776*n_x^10 - 3198552*n_x^9 + 6365599*n_x^8 - 7773202*n_x^7 + 5924490*n_x^6 - 2796336*n_x^5 + 645586*n_x^4 + 19470*n_x^3 - 30120*n_x^2 + 2520*n_x)*n_y^6 - (23*n_x^14 - 968*n_x^13 + 17382*n_x^12 - 163238*n_x^11 + 834367*n_x^10 - 2405947*n_x^9 + 4065108*n_x^8 - 4204679*n_x^7 + 2796336*n_x^6 - 1209662*n_x^5 + 272430*n_x^4 - 7920*n_x^3 - 2760*n_x^2)*n_y^5 + (15*n_x^14 - 582*n_x^13 + 11102*n_x^12 - 107571*n_x^11 + 498284*n_x^10 - 1196804*n_x^9 + 1560742*n_x^8 - 1200142*n_x^7 + 645586*n_x^6 - 272430*n_x^5 + 63840*n_x^4 - 3480*n_x^3)*n_y^4 - (5*n_x^14 - 250*n_x^13 + 4984*n_x^12 - 52507*n_x^11 + 209069*n_x^10 - 378693*n_x^9 + 280282*n_x^8 - 38980*n_x^7 - 19470*n_x^6 - 7920*n_x^5 + 3480*n_x^4)*n_y^3 - 5*(19*n_x^13 - 353*n_x^12 + 4141*n_x^11 - 13157*n_x^10 + 16474*n_x^9 - 1658*n_x^8 - 10938*n_x^7 + 6024*n_x^6 - 552*n_x^5)*n_y^2 + 15*(n_x^13 - 24*n_x^12 + 364*n_x^11 - 854*n_x^10 + 723*n_x^9 + 86*n_x^8 - 464*n_x^7 + 168*n_x^6)*n_y)
}
