% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unico.r
\name{Unico}
\alias{Unico}
\title{Fitting the Unico model}
\usage{
Unico(
  X,
  W,
  C1,
  C2,
  fit_tau = FALSE,
  mean_penalty = 0,
  var_penalty = 0.01,
  covar_penalty = 0.01,
  mean_max_iterations = 2,
  var_max_iterations = 3,
  nloptr_opts_algorithm = "NLOPT_LN_COBYLA",
  max_stds = 2,
  init_weight = "default",
  max_u = 1,
  max_v = 1,
  parallel = TRUE,
  num_cores = NULL,
  log_file = "Unico.log",
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{X}{An \code{m} by \code{n} matrix of measurements of \code{m} features for \code{n} observations. Each column in \code{X} is assumed to be a mixture of \code{k} sources. Note that \code{X} must include row names and column names and that NA values are currently not supported. \code{X} should not include features that are constant across all observations.}

\item{W}{An \code{n} by \code{k} matrix of weights - the weights of \code{k} sources for each of the \code{n} mixtures (observations). All the weights must be positive and each row - corresponding to the weights of a single observation - must sum up to 1. Note that \code{W} must include row names and column names and that NA values are currently not supported.}

\item{C1}{An \code{n} by \code{p1} design matrix of covariates that may affect the hidden source-specific values (possibly a different effect size in each source). Note that \code{C1} must include row names and column names and should not include an intercept term. NA values are currently not supported. Note that each covariate in \code{C1} results in \code{k} additional parameters in the model of each feature, therefore, in order to alleviate the possibility of model overfitting, it is advised to be mindful of the balance between the size of \code{C1} and the sample size in \code{X}.}

\item{C2}{An \code{n} by \code{p2} design matrix of covariates that may affect the mixture (i.e. rather than directly the sources of the mixture; for example, variables that capture biases in the collection of the measurements). Note that \code{C2} must include row names and column names and should not include an intercept term. NA values are currently not supported.}

\item{fit_tau}{A logical value indicating whether to fit the standard deviation of the measurement noise (i.e. the i.i.d. component of variation in the model denoted as \eqn{\tau}).}

\item{mean_penalty}{A non-negative numeric value indicating the regularization strength on the source-specific mean estimates.}

\item{var_penalty}{A non-negative numeric value indicating the regularization strength on the diagonal entries of the full \code{k} by \code{k} variance-covariance matrix.}

\item{covar_penalty}{A non-negative numeric value indicating the regularization strength on the off diagonal entries of the full \code{k} by \code{k} variance-covariance matrix.}

\item{mean_max_iterations}{A non-negative numeric value indicating the number of iterative updates performed on the mean estimates.}

\item{var_max_iterations}{A non-negative numeric value indicating the number of iterative updates performed on the variance-covariance matrix.}

\item{nloptr_opts_algorithm}{A string indicating the optimization algorithm to use.}

\item{max_stds}{A non-negative numeric value indicating, for each feature, the portions of data that are considered as outliers. Only samples within \code{max_stds} standard deviations from the mean will be used for the moments estimation of a given feature.}

\item{init_weight}{A string indicating the initial weights on the samples to start the iterative optimization.}

\item{max_u}{A non-negative numeric value indicating the maximum weights/influence a sample can have on mean estimates.}

\item{max_v}{A non-negative numeric value indicating the maximum weights/influence a sample can have on variance-covariance estimates.}

\item{parallel}{A logical value indicating whether to use parallel computing (possible when using a multi-core machine).}

\item{num_cores}{A numeric value indicating the number of cores to use (activated only if \code{parallel == TRUE}). If \code{num_cores == NULL} then all available cores except for one will be used.}

\item{log_file}{A path to an output log file. Note that if the file \code{log_file} already exists then logs will be appended to the end of the file. Set \code{log_file} to \code{NULL} to prevent output from being saved into a file; note that if \code{verbose == FALSE} then no output file will be generated regardless of the value of \code{log_file}.}

\item{verbose}{A logical value indicating whether to print logs.}

\item{debug}{A logical value indicating whether to set the logger to a more detailed debug level; set \code{debug} to \code{TRUE} before reporting issues.}
}
\value{
A list with the estimated parameters of the model. This list can be then used as the input to other functions such as \link{tensor}.
\item{W}{An \code{n} by \code{k} matrix of weights. This is the same as \code{W} from input.}
\item{C1}{An \code{n} by \code{p1} design matrix of source-specific covariates. This is the same as \code{C1} from input.}
\item{C2}{An \code{n} by \code{p2} design matrix of not source-specific covariates. This is the same as \code{C2} from input.}
\item{mus_hat}{An \code{m} by \code{k} matrix of estimates for the mean of each source in each feature.}
\item{gammas_hat}{An \code{m} by \code{k*p1} matrix of the estimated effects of the \code{p1} covariates in \code{C1} on each of the \code{m} features in \code{X}, where the first \code{p1} columns are the source-specific effects of the \code{p1} covariates on the first source, the following \code{p1} columns are the source-specific effects on the second source and so on.}
\item{betas_hat}{An \code{m} by \code{p2} matrix of the estimated effects of the \code{p2} covariates in \code{C2} on the mixture values of each of the \code{m} features in \code{X}.}
\item{sigmas_hat}{An \code{m} by \code{k} by \code{k} tensor of estimates for the cross source \code{k} by \code{k} variance-covariance matrix in each feature.}
\item{taus_hat}{An \code{m} by \code{1} matrix of estimates for the variance of the measurement noise.}
\item{scale.factor}{An \code{m} by \code{1} matrix of scaling factors for standardizing each feature.}
\item{config}{A list with hyper-parameters used for fitting the model and configurations for in the optimization algorithm.}
\item{Us_hat_list}{A list tracking, for each feature, the sample weights used for each iteration of the mean optimization  (activated only if \code{debug == TRUE}).}
\item{Vs_hat_list}{A list tracking, for each feature, the sample weights used for each iteration of the variance-covariance optimization  (activated only if \code{debug == TRUE}).}
\item{Ls_hat_list}{A list tracking, for each feature, the computed estimates of the upper triangular cholesky decomposition of variance-covariance matrix at each iteration of the variance-covariance optimization (activated only if \code{debug == TRUE}).}
\item{sigmas_hat_list}{A list tracking, for each feature, the computed estimates of the variance-covariance matrix at each iteration of the variance-covariance optimization (activated only if \code{debug == TRUE}).}
}
\description{
Fits the Unico model for an input matrix of features by observations that are coming from a mixture of \code{k} sources, under the assumption that each observation is a mixture of unique (unobserved) source-specific values (in each feature in the data). Specifically, for each feature, it standardizes the data and learns the source-specific mean and full \code{k} by \code{k} variance-covariance matrix.
}
\details{
Unico assumes the following model: \deqn{X_{ij} =  w_{i}^T Z_{ij} +(c_i^{(2)})^T \beta_j+ e_{ij}}
The mixture value at sample \eqn{i} feature \eqn{j}: \eqn{X_{ij}} is modeled as a weighted linear combination, specified by weights \eqn{w_i = (w_{i1},...,w_{ik})}, of a total of \eqn{k} source-specific levels, specified by \eqn{Z_{ij}=(Z_{ij1},...,Z_{ijk})}.
In addition, we also consider global-level covariates \eqn{c_i^{(2)}} that systematically affect the observed mixture values and their effect sizes \eqn{\beta_j}. \eqn{e_{ij}} denotes the i.i.d measurement noise with variance \eqn{\tau} across all samples.
Weights have be to non-negative and sum up to \eqn{1} across all sources for each sample. In practice, we assume that the weights are fixed and estimated by external methods.

Source specific profiles are further modeled as: \deqn{Z_{ijh} = \mu_{jh} + (c_i^{(1)})^T \gamma_{jh} + \epsilon_{ijh}}
\eqn{\mu_{jh}} denotes the population level mean of feature \eqn{j} at source \eqn{h}.
We also consider covariates \eqn{c_i^{(1)}} that systematically affect the source-specific values and their effect sizes \eqn{\gamma_{jh}} on each source.
Finally, we actively model the \eqn{k} by \eqn{k} covariance structure of a given feature \eqn{j} across all \eqn{k} sources \eqn{Var[\vec{\epsilon_{ij}}] = \Sigma_{j} \in \mathbf{R}^{k \times k}}.
}
\examples{
data = simulate_data(n=100, m=2, k=3, p1=1, p2=1, taus_std=0, log_file=NULL)
res = list()
res$params.hat = Unico(data$X, data$W, data$C1, data$C2, parallel=FALSE, log_file=NULL)

}
