% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimonAnalysis.R
\name{SimonAnalysis}
\alias{SimonAnalysis}
\title{Post-Trial Inference for ATS and ATSS Simon Designs}
\usage{
SimonAnalysis(m, s, n1, n2, r1, r, alpha, quantile, CI_option, p0)
}
\arguments{
\item{m}{Stopping stage of the ATS or ATSS Simon Designs}

\item{s}{The number of responses observed in total}

\item{n1}{The actual number of patients in stage 1}

\item{n2}{The actual total number of patients in stages 1 and 2}

\item{r1}{The design threshold in stage 1}

\item{r}{The design threshold in stage 2}

\item{alpha}{Type-I error rate}

\item{quantile}{Two tails probability of the confidence interval}

\item{CI_option}{The type of confidence interval, the character can be typed by
"CP", "Jung" or "MIDp" corresponding to the Clopper-Pearson, Jung exact,
or Midp confidence intervals}

\item{p0}{Unacceptable efficacy rate}
}
\value{
a data frame includes the Uniformly minimum-variance
unbiased estimator (UMVUE), chosen Confidence Interval and \emph{p}-Value
}
\description{
SimonAnalysis( ) can be used to calculate the Uniformly minimum-variance
unbiased estimator (UMVUE), Confidence Intervals (Clopper-Pearson, Jung exact,
and Mid-\emph{p}) and \emph{p}-Value given the design parameters obtained
from the Adaptive Threshold Simon Design (ATS Simon) design and Adaptive
Threshold and Sample Simon Design (ATSS Simon) design using ATS_Design( ),
ATSS_Design_Stage1( ) and ATSS_Design_Stage2( ).
}
\examples{
# Post-Trial inference for ATS or ATSS Simon Designs case 1
SimonAnalysis(2,7,13,30,3,12,0.05,c(0.025,0.975),"MIDp",0.40)
# Analysis Plan
#                      UMVUE CI(lower) CI(upper) p_Val
# Post-Trial Inference 0.322     0.108     0.538 0.831

# Post-Trial inference for ATS or ATSS Simon Designs case 2
SimonAnalysis(2,16,11,28,2,13,0.077,c(0.025,0.975),"Jung",0.25)
# Analysis Plan
#                     UMVUE CI(lower) CI(upper) p_Val
# Post-Trial Inference 0.429     0.257     0.568 0.019

}
\references{
Jung, S. H., & Kim, K. M. (2004).
\emph{On the estimation of the binomial probability in multistage clinical
trials. Statistics in medicine, 23(6), 881-896},
\doi{10.1002/sim.1653}.\cr
Clopper, C. J., & Pearson, E. S. (1934).
\emph{The use of confidence or fiducial limits illustrated in the case of
the binomial. Biometrika, 26(4),404-413},
\doi{10.2307/2331986}.\cr
Porcher, R., & Desseaux, K. (2012).
\emph{What inference for two-stage phase II trials?. BMC medical research methodology, 12, 1-13},
\doi{10.1186/1471-2288-12-117}.\cr
Jung, S. H., Owzar, K., George, S. L., & Lee, T. (2006).
\emph{P-value calculation for multistage phase II cancer clinical trials. Journal of Biopharmaceutical Statistics, 16(6), 765-775},
\doi{10.1080/10543400600825645}.
}
