\name{genPep}
\alias{genPep}
\title{
Peptide generator based on the output of functions \code{vComp} or \code{vMotif}
}
\description{
Generates the specified number of peptides whose positional composition is determined
by a weighted matrix given by the \pkg{VDAP} functions \code{vComp} or \code{vMotif}
}
\usage{
genPep(Struct,draw)
}
\arguments{
  \item{Struct}{
The output positional weight matrix from the \pkg{VDAP} functions
\code{vComp} or \code{vMotif}
}
\item{draw}{
An \code{integer} value, the number of peptides to be generated
}
}
\details{
The final composition of residues at each
position should reflect the relative weight present in the argument \code{Struct},
as the relative weights at each position are used to weight the sampling of amino acids
at each position.
}
\value{
A \code{data.frame} containing the number of peptides given by the argument \code{draw} in a single column.
}
\note{
The weighted values are squared before being used to weight random residue draws at each position.
This is donein order to further penalize peptides that appear less frequently than the global distribution
(Have weights < 1), and enrich peptides that appear more often than the global distribution (Have weights > 1).
}
\author{
Cody Moore
}
\seealso{
\code{vComp},\code{vMotif}
}
\examples{
protEx.Motif <- data.frame(Peptides = c("PWRGPWARVGSG","GYNRVGQGSG","PNGYRSGVKGSG","GSG"),
Length = c(12,10,12,3),Charge = c(2,1,2,0),Kd = c(0.2572361,2.8239730,3.3911868,281.3058),
C_6uM = c(65011.48,47462.24,24778,2613.03),C_6uM2 = c(62637.81,20723.85,21313.67,2300.216))

## Output weighted matrix generated by vMotif ##

vMotif.lcEx <- vMotif.lc(protEx.Motif,protEx.Motif, 12,2,5,Kd = FALSE)

## Generation of 10 peptides based on vMotif matrix weights##

genPepEx <- genPep(vMotif.lcEx,10)
}
\keyword{ ~Peptides }
\keyword{ ~generator }
