% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSampleDataCat.R
\name{generateSampleDataCat}
\alias{generateSampleDataCat}
\title{generateSampleDataCat}
\usage{
generateSampleDataCat(n, K, w, p, Irrp, yout = FALSE, cat = 2, ycat = 2)
}
\arguments{
\item{n}{Number of observations in dataset.}

\item{K}{Number of clusters desired.}

\item{w}{A vector of mixture weights (proportion of population in each
cluster).}

\item{p}{Number of clustering variables/covariates in dataset.}

\item{Irrp}{Number of irrelevant/noisy variables/covariates in dataset. Note
that these variables will be the final Irrp columns in the simulated
dataset. Total data dimension is p + Irrp.}

\item{yout}{Default FALSE. Indicate whether an outcome associated with
clustering is required.}

\item{cat}{Number of categories in each covariate. Default is 2.}

\item{ycat}{Number of categories for the outcome varaible. Default is 2.}
}
\value{
A list with the following components: 
  \item{data}{A matrix consisting of the simulated data.} 
  \item{trueClusters}{A vector with the simulated cluster assignments.}
  \item{outcome}{If yout = TRUE, this will be a vector with the outcome
  variable.}
}
\description{
Generate sample clustered categorical data with cluster labels. The
probability of a '1' in each cluster for each variable is randomly generated
via a Dirichlet (1, ..., cat) distribution, where cat is the number of
categories for each variable. For noisy variables, the probability of a '1'
is also generated by a Dirichlet (1, ..., cat) distribution but this
probability is the same regardless of the cluster membership of the
observation. An outcome variable associated with the clustering structure can
be generated with a different number of categories, also generated with a
Dirichlet distribution. Package 'gtools' must be installed for this function.
}
\examples{
# example code
generatedData <- generateSampleDataCat(1000, 4, c(0.1, 0.2, 0.3, 0.4), 100, 0, cat = 3)

}
