% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_plot.R
\name{ggplot.visitation_forecast_ensemble}
\alias{ggplot.visitation_forecast_ensemble}
\title{visitation_model visitation_forecast_ensemble ggplot Methods}
\usage{
\method{ggplot}{visitation_forecast_ensemble}(
  data,
  mapping = aes(),
  difference = FALSE,
  log_outputs = FALSE,
  plot_cumsum = FALSE,
  plot_percent_change = FALSE,
  actual_visitation = NULL,
  actual_visitation_label = "Actual",
  xlab = "Time",
  ylab = "Fitted Value",
  pred_colors = c("#ff6361", "#58508d", "#bc5090", "#003f5c"),
  actual_color = "#ffa600",
  size = 1.5,
  main = "Forecasts for Visitation Model",
  plot_points = FALSE,
  date_breaks = "1 month",
  date_labels = "\%y \%b",
  ...
)
}
\arguments{
\item{data}{An object of class visitation_forecast_ensemble.}

\item{mapping}{Default list of aesthetic mappings to use for plot. If not specified, must be supplied in each layer added to the plot.}

\item{difference}{A Boolean specifying whether to plot the original fit or differenced series. The default option is FALSE, in which case, the series is not differenced.}

\item{log_outputs}{whether to log the outputted forecasts or not}

\item{plot_cumsum}{whether to plot the cumulative sum or not}

\item{plot_percent_change}{whether to plot the percent change or not}

\item{actual_visitation}{A timeseries object representing the actual visitation that will be plotted along site the visitation_forecast object}

\item{actual_visitation_label}{a string that will be used for the label of the actual visitation.}

\item{xlab}{A string that will be used for the xlabel of the plot}

\item{ylab}{A string that will be used for the ylabel of the plot}

\item{pred_colors}{an array of Strings that will be used for the predicted series colors of the plot}

\item{actual_color}{a String that will be used for the actual series color of the plot,}

\item{size}{A number that represents the thickness of the lines being plotted}

\item{main}{A string that will be used for the title of the plot}

\item{plot_points}{a boolean to specify if the plot should be points or continous line.}

\item{date_breaks}{A string to represent the distance between dates that the x-axis should be in. ex "1 month", "1 year"}

\item{date_labels}{A string to represent the format of the x-axis time labels.}

\item{...}{extra arguments to pass in}
}
\value{
No return value, called for plotting objects of the class "visitation_forecast".
}
\description{
Method for plotting forecast ensemble with ggplot.
}
