% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_angle.R
\name{axis_angle}
\alias{axis_angle}
\title{Computes points angle with an axis (X, Y or Z) and the origin of the 3D cartesian coordinates system.}
\usage{
axis_angle(data, axis, project, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud or voxel cloud.}

\item{axis}{charecter. Specifying the reference axis to compute the angles: "X", "Y" or "Z".}

\item{project}{character. If specifyed the point cloud is projected into a 2D plan before computing the angles.
Can be "xy", "yz" or "xz". Default is without projection.}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.

 @references Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.}
}
\value{
A vector containing the angle values of the points.
}
\description{
Computes points angle with an axis (X, Y or Z) and the origin of the 3D cartesian coordinates system.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- compute angle with the Z axis
tls[,angle_z:=VoxR::axis_angle(tls,axis = "Z")]

#- compute angle with the X axis with projection in the xy plan
tls[,angle_x:=VoxR::axis_angle(tls,axis = "X",project = "xy")]

#- round angle values for visualization
tls[,angle_z:=round(angle_z)]
tls[,angle_x:=round(angle_x)]

#- plot the angle with Z axis
cols=rev(rainbow(max(tls$angle_z)+1,end=4/6)) # color scale
rgl::open3d()
rgl::plot3d(tls,col=cols[tls$angle_z+1],add=TRUE)

#- plot the angle with X axis
cols=rev(rainbow(max(tls$angle_x)+1,end=4/6)) # color scale
rgl::open3d()
rgl::plot3d(tls,col=cols[tls$angle_x+1],add=TRUE)
}
