% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qcond_gompertz}
\alias{qcond_gompertz}
\title{Quantile function for conditional Gompertz distribution (lower bound only)}
\usage{
qcond_gompertz(rnd, shape, rate, lower_bound = as.numeric(c(0)))
}
\arguments{
\item{rnd}{Vector of quantiles}

\item{shape}{The shape parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object}

\item{rate}{The rate parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object}

\item{lower_bound}{The lower bound of the conditional distribution}
}
\value{
Estimate(s) from the conditional Gompertz distribution based on given parameters
}
\description{
Quantile function for conditional Gompertz distribution (lower bound only)
}
\examples{
qcond_gompertz(rnd=0.5,shape=0.05,rate=0.01,lower_bound = 50)
}
