% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fun_icwt}
\alias{fun_icwt}
\title{Inverse of continuous wavelet transform}
\usage{
fun_icwt(x.wave, dt, dj, flag.wav = "WaveletComp", scale = NULL)
}
\arguments{
\item{x.wave}{input complex matrix.}

\item{dt}{sampling resolution in the time domain.}

\item{dj}{sampling resolution in the frequency domain.}

\item{flag.wav}{String for two different CWT packages.}

\item{scale}{Wavelet scales.}
}
\value{
reconstructed time series
}
\description{
Inverse of continuous wavelet transform
}
\examples{
set.seed(100)

dt<-1
dj<-1/8
flag.wav <- switch(2, "wmtsa", "WaveletComp")

n <- 100
x <- rnorm(n)
x.wave <- t(WaveletComp::WaveletTransform(x=x)$Wave)
rec <- fun_icwt(x.wave, dt, dj, flag.wav)

x.wt <- WaveletComp::analyze.wavelet(data.frame(x=x),"x",dt=dt,dj=dj)
rec_orig <- WaveletComp::reconstruct(x.wt,only.sig = FALSE, plot.rec = FALSE)$series$x.r

### compare to original series
op <- par(mfrow = c(1, 1), mar=c(3,3,1,1), mgp=c(1, 0.5, 0))
plot(1:n, x, type="l", lwd=5, xlab=NA, ylab=NA)
lines(1:n, rec, col="red",lwd=3)
lines(1:n, rec_orig, col="blue", lwd=1)
legend("topright",legend=c("Raw","Inverse","Inverse_orig"),
       lwd=c(5,3,1),bg="transparent",bty = "n",
       col=c("black","red","blue"),horiz=TRUE)
par(op)
}
\references{
fun_stoch_sim_wave in PRSim, Brunner and Furrer, 2020.
}
