% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CompoML}
\alias{CompoML}
\title{Fit a proportional means regression model for weighted composite endpoint
of recurrent event and death}
\usage{
CompoML(id, time, status, Z, w = NULL, ep = 1e-04)
}
\arguments{
\item{id}{A vector of unique patient identifiers.}

\item{time}{A vector of event times.}

\item{status}{A vector of event type labels. 0: censoring; 1: death;
2, 3,..., \eqn{K}: different types of (possibly recurrent) nonfatal event.}

\item{Z}{Covariate matrix (must be time-constant).}

\item{w}{A \eqn{K}-vector of weights assigned to event types 1 (death), 2, ..., \eqn{K}
(nonfatal events); If \code{NULL}, an unweighted endpoint is modeled
(i.e., with \code{w=c(1, 1, ..., 1)}).}

\item{ep}{Convergence threshold for the Newton-Raphson algorithm.}
}
\value{
An object of class \code{CompoML} with the following components.
\code{beta}: a vector of estimated regression coefficients (log-mean ratios);
\code{var}: estimated covariance matrix for \code{beta};
\code{t}: unique event times;
\code{y}: estimated baseline mean function (of \code{t}).
}
\description{
Fit a semiparametric proportional means regression model for the weighted
composite endpoint of recurrent event and death (Mao and Lin, 2016).
(Jared D. Huling (ORCID: 0000-0003-0670-4845) contributed to the optimization of this code.)
}
\examples{
\donttest{
## load package and data
library(Wcompo)
head(hfmock)
## fit a weighted PM (w_D=2, w_1=1)
obj <- CompoML(hfmock$id,hfmock$time,hfmock$status,hfmock[,c("Training","HF.etiology")],
               w=c(2,1))
## print out the result
obj

oldpar <- par(mfrow = par("mfrow"))
par(mfrow=c(1,2))
## plot the estimated mean function for
## non-ischemic patients by treatment
plot(obj,c(1,0),ylim=c(0,1.5),xlim=c(0,50),
     main="Non-ischemic",
     xlab="Time (months)",cex.main=1.2,lwd=2)
plot(obj,c(0,0),add=TRUE,cex.main=1.2,lwd=2,lty=2)
legend("topleft",lty=1:2,lwd=2,c("Exercise training","Usual care"))


## plot the estimated mean function for
## ischemic patients by treatment
plot(obj,c(1,1),ylim=c(0,1.5),xlim=c(0,50),
     main="Ischemic",
     xlab="Time (months)",cex.main=1.2,lwd=2)
plot(obj,c(0,1),add=TRUE,cex.main=1.2,lwd=2,lty=2)
legend("topleft",lty=1:2,lwd=2,c("Exercise training","Usual care"))
par(oldpar)
}
}
\references{
Mao, L. and Lin, D. Y. (2016). Semiparametric regression for the weighted
composite endpoint of recurrent and terminal events. Biostatistics, 17, 390-403.
}
\seealso{
\code{\link{plot.CompoML}}, \code{\link{print.CompoML}}
}
\keyword{CompoML}
