% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZetaSuitSC.R
\name{ZetaSuitSC}
\alias{ZetaSuitSC}
\title{Calculate zeta score for single cell RNA-seq quality control.}
\usage{
ZetaSuitSC(countMatSC, binNum = 10, filter = TRUE)
}
\arguments{
\item{countMatSC}{A matrix of single-cell RNA-seq count data where rows represent cells and columns represent genes.}

\item{binNum}{The number of bins for zeta score calculation. Default is 10. The function creates expression thresholds from 0 to the 80th percentile of non-zero expression values, divided into binNum intervals.}

\item{filter}{Logical. Whether to filter out cells with total read counts less than 100. Default is TRUE. This helps remove extremely low-quality cells before analysis.}
}
\value{
A list containing:
  \item{zetaData}{A data frame with two columns: 'Cell' (cell identifiers) and 'Zeta' (calculated zeta scores)}
  \item{p_cutoff}{A ggplot object showing the distribution of log10-transformed zeta scores with fitted Gaussian mixture components and the determined cutoff threshold}
}
\description{
This function evaluates the quality of cells detected in single-cell RNA-seq data by calculating a zeta score for each cell. The zeta score is based on the distribution of gene expression across different expression thresholds. A cutoff value is automatically determined using a two-component Gaussian mixture model to separate high-quality cells from low-quality or damaged cells.
}
\details{
The function works as follows:
\enumerate{
  \item Filters cells based on total read count if filter=TRUE
  \item Samples a subset of cells and genes for computational efficiency
  \item Creates expression thresholds (bins) from 0 to the 80th percentile of non-zero expression values
  \item For each cell, counts how many genes exceed each threshold
  \item Calculates the zeta score as a weighted sum of these counts
  \item Fits a two-component Gaussian mixture model to log10-transformed zeta scores
  \item Determines an optimal cutoff to separate high-quality from low-quality cells
}
}
\examples{
data(countMatSC)
\donttest{zetaDataSC <- ZetaSuitSC(countMatSC, binNum=50, filter=TRUE)}

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
\keyword{cell}
\keyword{control}
\keyword{quality}
\keyword{single}
