% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estcov.R
\name{estcov}
\alias{estcov}
\title{estcov}
\usage{
estcov(allZ, Ps = FALSE)
}
\arguments{
\item{allZ}{matrix of summary Z-scores for all SNP. each row for SNP; each column for single trait.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}
}
\value{
estimated correlation matrix.
}
\description{
Estimate the covariance matrix of multiple traits based on their (null) summary Z-scores.
}
\examples{

# -- n.snp: number of SNPs
# -- n.trait: number of traits
# -- n.subject: number of subjects

n.snp <- 100
n.traits <- 10
n.subjects <- 1000
traits <- matrix(rnorm(n.subjects*n.traits), n.subjects, n.traits)
v <- cov(traits)
allZ <- rmvnorm(n.snp, Sigma=v)
colnames(allZ) <- paste("trait", 1:n.traits, sep="")
rownames(allZ) <- paste("snp", 1:n.snp, sep="")


r <- estcov(allZ)
MTaSPUs(Z = allZ, v = r, B = 100, pow = c(1:4, Inf), transform = FALSE)
MTaSPUs(Z = allZ[1,], v = r, B = 100, pow = c(1:4, Inf), transform = FALSE)
minP(Zi= allZ[1,], r = r)

}
\references{
Junghi Kim, Yun Bai and Wei Pan (2015) An Adaptive Association Test for Multiple Phenotypes with GWAS Summary Statistics, Genetic Epidemiology, 8:651-663
}
\seealso{
\code{\link{MTaSPUs}} \code{\link{minP}}
}
\author{
Junghi Kim, Yun Bai and Wei Pan
}
