% Generated by roxygen2 (4.0.2): do not edit by hand
\name{accurate}
\alias{accurate}
\title{Accurate Computation}
\usage{
accurate(x, x.hat, k, output = TRUE)
}
\arguments{
\item{x}{a numeric vector of original values.}

\item{x.hat}{a numeric vector of smoothed (fitted) values.}

\item{k}{the number of parameters in obtaining the smoothed (fitted) values.}

\item{output}{a logical value indicating to print the results in R console. The default is
\code{TRUE}.}
}
\value{
A vector containing the following components:
\item{SST}{the total sum of squares.}
\item{SSE}{the sum of the squared residuals.}
\item{MSE}{the mean squared error.}
\item{RMSE}{the root mean square error.}
\item{MAPE}{the mean absolute percent error.}
\item{MPE}{the mean percent error.}
\item{MAE}{the mean absolute error.}
\item{ME}{the mean error.}
\item{R.squared}{R^2 = 1 - SSE/SST.}
\item{R.adj.squared}{the adjusted R^2.}
\item{RW.R.squared}{the random walk R^2.}
\item{AIC}{the Akaike's information criterion.}
\item{SBC}{the Schwarz's Bayesian criterion.}
\item{APC}{the Amemiya's prediction criterion}
}
\description{
Computes the accurate criterion of smoothed (fitted) values.
}
\details{
See \url{http://www.dms.umontreal.ca/~duchesne/chap12.pdf} in page 616 - 617 for
the details of calculations for each criterion.
}
\note{
If the model fits the series badly, the model error sum of squares \code{SSE}
may be larger than \code{SST} and the \code{R.squared} or \code{RW.R.squared} statistics
will be negative. The \code{RW.R.squared} uses the random walk model for the purpose of
comparison.
}
\examples{
X <- matrix(rnorm(200),100,2)
y <- 0.1*X[,1] + 2*X[,2] + rnorm(100)
y.hat <- fitted(lm(y ~ X))
accurate(y,y.hat,2)
}
\author{
Debin Qiu
}

