% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydrate_tweets.R
\name{hydrate_tweets}
\alias{hydrate_tweets}
\title{Hydrate Tweets Based On Tweet IDs}
\usage{
hydrate_tweets(
  ids,
  bearer_token = get_bearer(),
  data_path = NULL,
  context_annotations = FALSE,
  bind_tweets = TRUE,
  verbose = TRUE,
  errors = FALSE
)
}
\arguments{
\item{ids}{a character vector of Tweet IDs}

\item{bearer_token}{string, bearer token}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{context_annotations}{If \code{TRUE}, context_annotations will be fetched.}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{errors}{logical, if \code{TRUE}, the error capturing mechanism is enabled. See details below.}
}
\value{
When bind_tweets is \code{TRUE}, the function returns a data frame. The \code{data_path} (invisibly) if \code{bind_tweets} is \code{FALSE}
}
\description{
This function is helpful for hydrating Tweet IDs (i.e. getting the full content of tweets from a list of Tweet IDs).
}
\details{
When the error capturing mechanism is enabled, Tweets IDs that cannot be queried (e.g. with error) are stored as \code{errors_*.json} files. If \code{bind_tweets} is TRUE, those error Tweets IDs are retained in the returned data.frame with the column \code{error} indicating the error.
}
\examples{
\dontrun{
hydrate_tweets(c("1266876474440761346", "1266868259925737474", "1266867327079002121",
"1266866660713127936", "1266864490446012418", "1266860737244336129",
"1266859737615826944", "1266859455586676736", "1266858090143588352",
"1266857669157097473"))
}
}
