% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gddprism.R
\name{gddprism}
\alias{gddprism}
\title{Calculating GDDs by PRISM grids or Counties with PRISM raster}
\usage{
gddprism(
  minprism,
  maxprism,
  year,
  tL,
  tU,
  method = c("stri", "ssin"),
  out = NULL
)
}
\arguments{
\item{minprism}{A PRISM raster of the minimum temperature}

\item{maxprism}{A PRISM raster of the maximum temperature}

\item{year}{year of the PRIsM raster of minprism and maxprism}

\item{tL}{Lower temperature threshold}

\item{tU}{Upper temperature threshold}

\item{method}{GDD calculation methods: single sine or single triangulation only (default = single sine method)}

\item{out}{Output value type: GDDs by PRISM grids or Counties (default = Counties)}
}
\value{
A data.frame including GDDs (gdd), PRISM grid numbers (gridNum), or FIPS codes (stco)
}
\description{
The function calculates the growing season degree days (GDDs) by grids or counties directly from a PRISM raster.
}
\details{
\code{gddprism} is a function for calculating growing season degree days (GDDs) by PRISM grids or Counties directly from a PRISM raster.\cr
\cr
Only single methods (single sine or single triangulation) are applicable by specifying method.\cr 
- \code{method = 'stri'}: single triangulation method
\cr
- \code{method = 'ssin'}: single sine method (default)\cr
\cr
The \code{out} is to specify the output values.\cr
- \code{out = 'grid'}: GDDs by PRISM grids projected on the NLCD map
\cr
- \code{out = 'stco'}: GDDs by Counties of 2017 Agricultural Census (default)
\cr
If \code{out} is not specified, 'stco' is set as default.\cr
\cr
When \code{out='stco'} is specified, the weights are applied as:\cr
- year < 2004: agricultural areas in 2001 NLCD
\cr
- year = 2004 or 2005: agricultural areas in 2004 NLCD
\cr
- year = 2006 or 2007: agricultural areas in 2006 NLCD
\cr
- year = 2008, 2009, or 2010: agricultural areas in 2008 NLCD
\cr
- year = 2011 or 2012: agricultural areas in 2011 NLCD
\cr
- year = 2013, 2014, or 2015: agricultural areas in 2013 NLCD
\cr
- year = 2016, 2017, or 2018: agricultural areas in 2016 NLCD
\cr
- year >= 2019: agricultural areas in 2019 NLCD\cr
\cr
To get a PRIMS raster, follow the instruction at \url{https://prism.oregonstate.edu/documents/PRISM_downloads_FTP.pdf}.
}
\examples{
#######################################################
## Note: Need PRISM rasters to run this code
#######################################################
\dontrun{
## PRISM data import
maxdata <- raster('./PRISM_tmax_stable_4kmD1_19960701_bil.bil')
mindata <- raster('./PRISM_tmin_stable_4kmD1_19960701_bil.bil')
## Single Sine Methods over Counties
result1 <- gddprism(mindata,maxdata,1996,8,30,'ssin')
result2 <- gddprism(mindata,maxdata,1996,8,30,'ssin','stco')
## Single Sine Method over PRISM grids 
result3 <- gddprism(mindata,maxdata,1996,8,30,'ssin','grid')
## Single Triangulation over Counties
result4 <- gddprism(mindata,maxdata,1996,8,30,'stri')
}
}
\seealso{
\code{\link{gddcal}, \link{pptprism}, \link{grid2stco}}
}
