% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extdata.R
\name{GSE11976_CRL2324}
\alias{GSE11976_CRL2324}
\title{Annotated copy-number regions from the GEO GSE11976 data set.}
\format{A data frame with 770668 observations of 7 variables: 
\describe{ 
  \item{c}{total copy number (not log-scaled)} 
  \item{b}{allelic ratios in the
  diluted tumor sample (after TumorBoost)} 
  \item{genotype}{germline
  genotypes} 
  \item{region}{a character value, annotation label for the region. Should be
  encoded as \code{"(C1,C2)"}, where \code{C1} denotes the minor copy number
  and \code{C2} denotes the major copy number.  For example, 
  \describe{ 
  \item{(1,1)}{Normal} \item{(0,1)}{Hemizygous deletion} 
  \item{(0,0)}{Homozygous deletion} \item{(1,2)}{Single copy gain} 
  \item{(0,2)}{Copy-neutral LOH} \item{(2,2)}{Balanced two-copy gain} 
  \item{(1,3)}{Unbalanced two-copy gain} \item{(0,3)}{Single-copy gain with
  LOH} } }
  \item{cellularity}{A numeric value between 0 and 1, the percentage of tumor cells in the  sample.}
  }
 @source http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE11976
 @references Staaf, J., Lindgren, D., Vallon-Christersson, J., Isaksson, A., 
 Goransson, H., Juliusson, G., ... & Ringn\'er, M. (2008). 
 Segmentation-based detection of allelic imbalance and 
 loss-of-heterozygosity in cancer cells using whole genome SNP arrays. 
 Genome Biol, 9(9), R136.}
\description{
The GEO GSE11976 data set is a dilution series from the Illumina 
HumanCNV370v1 chip type (Staaf et al, 2008).
}
\details{
These data have been processed from the files available at 
http://cbbp.thep.lu.se/~markus/software/BAFsegmentation/ using scripts that 
are included in the 'inst/preprocessing/GSE11976' directory of this package.
}
\examples{
dat <- loadCnRegionData("GSE11976_CRL2324")
unique(dat$region)
}

