% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mince}
\alias{mince}
\title{Prepare input string}
\usage{
mince(
  input,
  ignore_articles = TRUE,
  alnum_only = TRUE,
  bow = FALSE,
  bow_prop = 0.5
)
}
\arguments{
\item{input}{Character vector with text to use as the input for the candidate}

\item{ignore_articles}{Logical indicating whether or not articles should be ignored ; default is \code{TRUE}}

\item{alnum_only}{Logical that specifes whether only alphanumeric should be used; default is \code{TRUE}}

\item{bow}{Logical for whether or not a "bag of words" approach should be used for "input" vector; default is \code{FALSE}}

\item{bow_prop}{Given \code{bow = TRUE} this specifies the proportion of words to sample; ignored if \code{bow = FALSE}; default is \code{0.5}}
}
\value{
Named list with the following elements:
\itemize{
\item \strong{words}: Vector with one element per word to be used in the acronym or initialism
\item \strong{collapsed}: Vector of length 1 containing all characters from words collapsed
\item \strong{words_len}: Vector containing length of each word
\item \strong{first_chars}: Vector containing first character from each word
}
}
\description{
This helper is used by both \link[acroname]{acronym} and \link{initialism} to extract elements needed from the input string.

If the function is used with \code{bow = TRUE} the input will be processed with a "bag of words" approach, by which words will be shuffled and sampled without replacement. In this case, the number of characters used will be determined by the proportion passed to "bow_prop".
}
