% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepArchetypesRawData_norm_frob.R
\name{stepArchetypesRawData_norm_frob}
\alias{stepArchetypesRawData_norm_frob}
\title{Archetype algorithm to raw data with the Frobenius norm}
\usage{
stepArchetypesRawData_norm_frob(data, numArch, numRep = 3, 
                                verbose = TRUE, saveHistory = FALSE)
}
\arguments{
\item{data}{Data to obtain archetypes.}

\item{numArch}{Number of archetypes to compute, from 1 to \code{numArch}.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{verbose}{If TRUE, the progress during execution is shown.}

\item{saveHistory}{Save execution steps.}
}
\value{
A list with the archetypes.
}
\description{
This is a slight modification of \code{\link[Anthropometry]{stepArchetypesRawData}}
to use the archetype algorithm with the Frobenius norm.
}
\examples{
data(mtcars)
data <- as.matrix(mtcars)

numArch <- 5 
numRep <- 2

lass <- stepArchetypesRawData_norm_frob(data = data, numArch = 1:numArch, 
                                        numRep = numRep, verbose = FALSE)
                                        
str(lass)   
length(lass[[1]])
class(lass[[1]])  
                                                   
}
\references{
Eugster, M.J.A. and Leisch, F., From Spider-Man to Hero - Archetypal Analysis in 
R, 2009. \emph{Journal of Statistical Software} \bold{30(8)}, 1-23,
\url{https://doi.org/10.18637/jss.v030.i08}

Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2019. 
\emph{Physica A: Statistical Mechanics and its Applications} \bold{519}, 195-208. 
\url{https://doi.org/10.1016/j.physa.2018.12.036}

Vinue, G., Epifanio, I., and Alemany, S., Archetypoids: a new approach to 
define representative archetypal data, 2015.
\emph{Computational Statistics and Data Analysis} \bold{87}, 102-115,
\url{https://doi.org/10.1016/j.csda.2015.01.018}

Vinue, G., Anthropometry: An R Package for Analysis of Anthropometric Data, 2017.
\emph{Journal of Statistical Software} \bold{77(6)}, 1-39,
\url{https://doi.org/10.18637/jss.v077.i06}
}
\seealso{
\code{\link[Anthropometry]{stepArchetypesRawData}}, 
\code{\link[archetypes]{stepArchetypes}}
}
\author{
Irene Epifanio
}
