% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{summary.adaptProj}
\alias{summary.adaptProj}
\title{Summarize adaptProj Objects}
\usage{
\method{summary}{adaptProj}(
  object,
  threshold = 1,
  inf_alive = TRUE,
  milepost = c(0, 0.25, 0.5, 0.75, 1),
  ext_time = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{adaptProj} object.}

\item{threshold}{A threshold population size to be searched for in
projections. Defaults to 1.}

\item{inf_alive}{A logical value indicating whether to treat infinitely
large population size as indicating that the population is still extant.
If \code{FALSE}, then the population is considered extinct. Defaults to
\code{TRUE}.}

\item{milepost}{A numeric vector indicating at which points in the projection
to assess detailed results. Can be input as integer values, in which case
each number must be between 1 and the total number of occasions projected in
each projection, or decimals between 0 and 1, which would then be translated
into the corresponding projection steps of the total. Defaults to
\code{c(0, 0.25, 0.50, 0.75, 1.00)}.}

\item{ext_time}{A logical value indicating whether to output extinction times
per population-patch. Defaults to \code{FALSE}.}

\item{...}{Other parameters currently not utilized.}
}
\value{
Apart from a statement of the results, this function outputs a list
with the following elements:
\item{milepost_sums}{A data frame showing the number of replicates at each
of the milepost times that is above the threshold population/patch size.}
\item{extinction_times}{A dataframe showing the numbers of replicates going
extinct (\code{ext_reps}) and mean extinction time (\code{ext_time}) per
population-patch. If \code{ext_time = FALSE}, then only outputs \code{NA}.}
}
\description{
Function \code{summary.adaptProj()} summarizes \code{adaptProj} objects.
}
\section{Notes}{

The \code{inf_alive} and \code{ext_time} options both assess whether
replicates have reached a value of \code{NaN} or \code{Inf}. If
\code{inf_alive = TRUE} or \code{ext_time = TRUE} and one of these values is
found, then the replicate is counted in the \code{milepost_sums} object if
the last numeric value in the replicate is above the \code{threshold} value,
and is counted as extant and not extinct if the last numeric value in the
replicate is above the extinction threshold of a single individual.

Extinction time is calculated on the basis of whether the replicate ever
falls below a single individual. A replicate with a positive population size
below 0.0 that manages to rise above 1.0 individual is still considered to
have gone extinct the first time it crossed below 1.0.

If the input \code{lefkoProj} object is a mixture of two or more other
\code{lefkoProj} objects, then mileposts will be given relative to the
maximum number of time steps noted.
}

\examples{
library(lefko3)
data(cypdata)

data(cypa_data)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cycaraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)
  
cyparaw_v1 <- verticalize3(data = cypa_data, noyears = 18, firstyear = 1994,
  individcol = "plant_id", blocksize = 2, sizeacol = "Inf.94",
  sizebcol = "Veg.94", repstracol = "Inf.94", fecacol = "Inf.94",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)
cyp_supp_list1 <- list(cypsupp2r, cypsupp2r)

cycamatrix2r <- rlefko2(data = cycaraw_v1, stageframe = cypframe_raw, 
  year = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", indivcol = "individ")

cypamatrix2r <- rlefko2(data = cyparaw_v1, stageframe = cypframe_raw, 
  year = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", indivcol = "individ")

cyp_mpm_list <- list(cycamatrix2r, cypamatrix2r)

cyca2_start <- start_input(cycamatrix2r, stage2 = c("SD", "P1", "P2"),
  value = c(500, 100, 200))
cypa2_start <- start_input(cypamatrix2r, stage2 = c("SD", "P1", "P2"),
  value = c(5000, 1000, 2000))
cyp_start_list <- list(cyca2_start, cypa2_start)

cyp2_dv <- density_input(cypamatrix2r, stage3 = c("SD", "P1"),
  stage2 = c("rep", "rep"), style = c(1, 1), alpha = c(0.5, 1.2),
  beta = c(1.0, 2.0), type = c(2, 1))
cyp_dv_list <- list(cyp2_dv, cyp2_dv)

cyp_comm_proj <- project3(mpms = cyp_mpm_list, starts = cyp_start_list,
  density = cyp_dv_list, times = 10)
  
summary(cyp_comm_proj)


}
