% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_estimator.R
\name{evaluate_estimator-methods}
\alias{evaluate_estimator-methods}
\alias{evaluate_estimator,PointEstimatorScore,IntervalEstimator-method}
\alias{evaluate_estimator,IntervalEstimatorScore,PointEstimator-method}
\alias{evaluate_estimator,list,Estimator-method}
\alias{evaluate_estimator,Expectation,PointEstimator-method}
\alias{evaluate_estimator,Bias,PointEstimator-method}
\alias{evaluate_estimator,Variance,PointEstimator-method}
\alias{evaluate_estimator,MSE,PointEstimator-method}
\alias{evaluate_estimator,OverestimationProbability,PointEstimator-method}
\alias{evaluate_estimator,Coverage,IntervalEstimator-method}
\alias{evaluate_estimator,SoftCoverage,IntervalEstimator-method}
\alias{evaluate_estimator,Width,IntervalEstimator-method}
\alias{evaluate_estimator,TestAgreement,IntervalEstimator-method}
\alias{evaluate_estimator,TestAgreement,PValue-method}
\alias{evaluate_estimator,Centrality,PointEstimator-method}
\title{Evaluate performance characteristics of an estimator}
\usage{
\S4method{evaluate_estimator}{PointEstimatorScore,IntervalEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{IntervalEstimatorScore,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{list,Estimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{Expectation,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{Bias,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{Variance,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{MSE,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{OverestimationProbability,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{Coverage,IntervalEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{SoftCoverage,IntervalEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{Width,IntervalEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{TestAgreement,IntervalEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{TestAgreement,PValue}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)

\S4method{evaluate_estimator}{Centrality,PointEstimator}(
  score,
  estimator,
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  true_parameter = mu,
  mu,
  sigma,
  tol = getOption("adestr_tol_outer", default = .adestr_options[["adestr_tol_outer"]]),
  maxEval = getOption("adestr_maxEval_outer", default =
    .adestr_options[["adestr_maxEval_outer"]]),
  absError = getOption("adestr_absError_outer", default =
    .adestr_options[["adestr_absError_outer"]]),
  exact = FALSE,
  early_futility_part = TRUE,
  continuation_part = TRUE,
  early_efficacy_part = TRUE,
  conditional_integral = FALSE
)
}
\arguments{
\item{score}{performance measure to evaluate.}

\item{estimator}{object of class \code{PointEstimator}, \code{IntervalEstimator} or \code{PValue}.}

\item{data_distribution}{object of class \code{Normal} or \code{Student}.}

\item{use_full_twoarm_sampling_distribution}{logical indicating whether this estimator is intended to be used
with the full sampling distribution in a two-armed trial.}

\item{design}{object of class \code{TwoStageDesign}.}

\item{true_parameter}{true value of the parameter (used e.g. when evaluating bias).}

\item{mu}{expected value of the underlying normal distribution.}

\item{sigma}{assumed standard deviation.}

\item{tol}{relative tolerance.}

\item{maxEval}{maximum number of iterations.}

\item{absError}{absolute tolerance.}

\item{exact}{logical indicating usage of exact n2 function.}

\item{early_futility_part}{include early futility part of integral.}

\item{continuation_part}{include continuation part of integral.}

\item{early_efficacy_part}{include early efficacy part of integral.}

\item{conditional_integral}{treat integral as a conditional integral.}
}
\value{
an object of class \code{EstimatorScoreResult}
containing the values of the evaluated \code{\link{EstimatorScore}} and
information about the setting for which they were calculated
(e.g. the \code{estimator}, \code{data_distribution}, \code{design}, \code{mu}, and \code{sigma}).
}
\description{
This function evaluates an \code{\link{EstimatorScore}} for a \code{\link{PointEstimator}}
or and \code{\link{IntervalEstimator}} by integrating over the sampling distribution.
}
\details{
\subsection{General}{

First, a functional representation of the integrand is created by combining information
from the \code{\link{EstimatorScore}} object (\code{score}) and the \code{\link{PointEstimator}} or
\code{\link{IntervalEstimator}} object (\code{estimator}).
The sampling distribution of a design is determined by the \code{TwoStageDesign} object
(\code{design}) and the \code{DataDistribution} object (\code{data_distribution}),
as well as the assumed parameters \eqn{\mu} (mu) and \eqn{\sigma} (sigma).
The other parameters control various details of the integration problem.
}

\subsection{Other parameters}{

For a two-armed \code{data_distribution},
if \code{use_full_twoarm_sampling_distribution} is \code{TRUE}, the sample means
for both groups are integrated independently. If \code{use_full_twoarm_sampling_distribution}
is \code{FALSE}, only the difference in sample means is integrated.

\code{true_parameter} controls which parameters is supposed to be estimated. This
is usually \code{mu}, but could be set to \code{sigma} if one is interested in
estimating the standard deviation.

If the parameter \code{exact} is set to \code{FALSE}
(the default), the continuous version of the second-stage sample-size function \code{n2}
is used. Otherwise, an integer valued version of that function will be used,
though this is considerably slower.

The parameters \code{early_futility_part},
\code{continuation_part} and \code{early_efficacy_part} control which parts
of the sample-space should be integrated over (all default to \code{TRUE}).
They can be used in conjunction with the parameter \code{conditional_integral},
which enables the calculation of the expected value of performance score conditional
on reaching any of the selected integration regions.

Lastly, the paramters
\code{tol}, \code{maxEval}, and \code{absError} control the integration accuracy.
They are handed down to the \code{\link[cubature]{hcubature}} function.
}
}
\examples{
evaluate_estimator(
  score = MSE(),
  estimator = SampleMean(),
  data_distribution = Normal(FALSE),
  design = get_example_design(),
  mu = c(0, 0.3, 0.6),
  sigma = 1,
  exact = FALSE
)

evaluate_estimator(
  score = Coverage(),
  estimator = StagewiseCombinationFunctionOrderingCI(),
  data_distribution = Normal(FALSE),
  design = get_example_design(),
  mu = c(0, 0.3),
  sigma = 1,
  exact = FALSE
)

}
\seealso{
\link{EstimatorScore}

\link{PointEstimator} \link{IntervalEstimator}

\link[adestr:plot,EstimatorScoreResultList-method]{plot}
}
