% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_tmb_deprecated.R
\name{sample_tmb_hmc}
\alias{sample_tmb_hmc}
\title{Draw MCMC samples from a model posterior using a static HMC sampler.}
\usage{
sample_tmb_hmc(
  iter,
  fn,
  gr,
  init,
  L,
  eps,
  warmup = floor(iter/2),
  seed = NULL,
  chain = 1,
  thin = 1,
  control = NULL
)
}
\arguments{
\item{iter}{The number of samples to draw.}

\item{fn}{A function that returns the log of the posterior density.}

\item{gr}{A function that returns a vector of gradients of the log of
the posterior density (same as \code{fn}).}

\item{init}{A list of lists containing the initial parameter
vectors, one for each chain or a function. It is strongly
recommended to initialize multiple chains from dispersed
points. A of NULL signifies to use the starting values
present in the model (i.e., \code{obj$par}) for all chains.}

\item{L}{The number of leapfrog steps to take. The NUTS algorithm does
not require this as an input. If \code{L=1} this function will perform
Langevin sampling. In some contexts \code{L} can roughly be thought of
as a thinning rate.}

\item{eps}{The step size. If a numeric value is passed, it will be used
throughout the entire chain. A \code{NULL} value will initiate
sampler_params of \code{eps} using the dual averaging algorithm during
the first \code{warmup} steps.}

\item{warmup}{The number of warmup iterations.}

\item{seed}{The random seed to use.}

\item{chain}{The chain number, for printing only.}

\item{thin}{The thinning rate to apply to samples. Typically
not used with NUTS.}

\item{control}{A list to control the sampler. See details for
further use.}
}
\value{
A list containing samples ('par') and algorithm details such as
  step size adaptation and acceptance probabilities per iteration
  ('sampler_params').
}
\description{
Draw MCMC samples from a model posterior using a static HMC sampler.
}
\details{
This function implements algorithm 5 of Hoffman and Gelman
  (2014), which includes adaptive step sizes (\code{eps}) via an
  algorithm called dual averaging.
}
\references{
\itemize{ \item{Neal, R. M. (2011). MCMC using Hamiltonian
  dynamics. Handbook of Markov Chain Monte Carlo.}  \item{Hoffman and
  Gelman (2014). The No-U-Turn sampler: Adaptively setting path lengths
  in Hamiltonian Monte Carlo. J. Mach. Learn. Res.  15:1593-1623.}  }

Hoffman and Gelman (2014). The No-U-Turn sampler: Adaptively setting
  path lengths in Hamiltonian Monte Carlo. J. Mach. Learn. Res.
  15:1593-1623.
}
\seealso{
\code{\link{sample_tmb}}

\code{\link{sample_tmb}}
}
