% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Survival.R
\docType{class}
\name{Survival-class}
\alias{Survival-class}
\alias{Survival}
\alias{quantile,Survival-method}
\alias{simulate,Survival,numeric-method}
\title{Log-rank test}
\usage{
Survival(event_rate, two_armed = TRUE)

\S4method{quantile}{Survival}(x, probs, n, theta, ...)

\S4method{simulate}{Survival,numeric}(object, nsim, n, theta, seed = NULL, ...)
}
\arguments{
\item{event_rate}{probability that a subject will eventually have an event}

\item{two_armed}{logical indicating if a two-armed trial is regarded}

\item{x}{outcome}

\item{probs}{vector of probabilities}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}

\item{object}{object of class \code{Survival}}

\item{nsim}{number of simulation runs}

\item{seed}{random seed}
}
\description{
Implements the normal approximation of the log-rank test statistic.
}
\section{Slots}{

\describe{
\item{\code{event_rate}}{cf. parameter 'event_rate'}
}}

\examples{
datadist <- Survival(event_rate=0.6, two_armed=TRUE)

}
\seealso{
see \code{\link{probability_density_function}} and
\code{\link{cumulative_distribution_function}} to evaluate the pdf
and the cdf, respectively.
}
