% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_query.R
\name{start_query}
\alias{start_query}
\title{start_query}
\usage{
start_query(
  query_name,
  ads_data_customer_id,
  bq_destination_table,
  start_date,
  end_date,
  token
)
}
\arguments{
\item{query_name}{e.g. customers/123/analysisQueries/abcd1234'}

\item{ads_data_customer_id}{#Enter the "From" ADH account on which we want to run the query}

\item{bq_destination_table}{BigQuery destination table ID e.g. "project.dataset.table_name" If specified, the project must be explicitly whitelisted for the customer's ADH account. If project is not specified, uses default project for the provided customer. If neither project nor dataset is specified, uses the default project and dataset.}

\item{start_date}{Start Date e.g. 2021-01-31  format: YYYY-MM-DD}

\item{end_date}{End Date e.g. 2021-01-31 format: YYYY-MM-DD}

\item{token}{Access token retrived from function google_auth()}
}
\value{
If successful, the response body contains an instance of the submitted job.
}
\description{
Starts execution on a stored analysis query. The results will be written to the specified BigQuery destination table. The returned operation name can be used to poll for query completion status.. Reference: <https://developers.google.com/ads-data-hub/reference/rest/v1/customers.analysisQueries/start>
}
\examples{
\dontrun{
library(adsDataHubR)
token <- google_auth(client_id = client_id, client_secret=client_secret)
start_query(query_name, ads_data_customer_id, bq_destination_table, start_date, end_date, token)
}
}
