% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmReadVeeco.R
\name{afmReadVeeco}
\alias{afmReadVeeco}
\title{Read Bruke Nanoscope Veeco ascii file}
\usage{
afmReadVeeco(
  filename,
  path = ".",
  FColStr = "pN",
  ZColStr = "Ramp",
  tColStr = "Time",
  TimeCol = TRUE,
  silent = FALSE
)
}
\arguments{
\item{filename}{String with the name of the jpk file.}

\item{path}{Path to the folder where the file is.}

\item{FColStr}{String pattern identifying the Force columns (defaults to "pN")}

\item{ZColStr}{String pattern identifying the Z columns (defaults to "Ramp")}

\item{tColStr}{String pattern identifying the Time columns (defaults to "Time")}

\item{TimeCol}{Logical value. If TRUE (default) there is a Time column.}

\item{silent}{Logical parameter. If TRUE it suppresses the messages regarding the loading of the JPK file (defaults to FALSE).}
}
\value{
A afmdata structure list containing a field 'data' which is a data frame with 
variables Force, Z, Time (if aplicable) and Segment ("approach", "retract" and/or "pause") and 
a field 'params' which is a list with the fields 'curvename' and 'SpringConstant'.
}
\description{
Read an ascii Veeco file.

Reads an ascii Veeco file with one or two segments.
}
\examples{
data <- afmReadVeeco("veeco_file.txt.gz",path = path.package("afmToolkit"))
str(data)
}
