% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_AgghooCV.R
\name{AgghooCV}
\alias{AgghooCV}
\title{R6 class with agghoo functions fit() and predict().}
\description{
Class encapsulating the methods to run to obtain the best predictor
from the list of models (see 'Model' class).
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AgghooCV-new}{\code{AgghooCV$new()}}
\item \href{#method-AgghooCV-fit}{\code{AgghooCV$fit()}}
\item \href{#method-AgghooCV-predict}{\code{AgghooCV$predict()}}
\item \href{#method-AgghooCV-getParams}{\code{AgghooCV$getParams()}}
\item \href{#method-AgghooCV-clone}{\code{AgghooCV$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgghooCV-new"></a>}}
\if{latex}{\out{\hypertarget{method-AgghooCV-new}{}}}
\subsection{Method \code{new()}}{
Create a new AgghooCV object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgghooCV$new(data, target, task, gmodel, loss)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Matrix or data.frame}

\item{\code{target}}{Vector of targets (generally numeric or factor)}

\item{\code{task}}{"regression" or "classification".
Default: classification if target not numeric.}

\item{\code{gmodel}}{Generic model returning a predictive function
Default: tree if mixed data, knn/ppr otherwise.}

\item{\code{loss}}{Function assessing the error of a prediction
Default: error rate or mean(abs(error)).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgghooCV-fit"></a>}}
\if{latex}{\out{\hypertarget{method-AgghooCV-fit}{}}}
\subsection{Method \code{fit()}}{
Fit an agghoo model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgghooCV$fit(CV = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{CV}}{List describing cross-validation to run. Slots: \cr
  - type: 'vfold' or 'MC' for Monte-Carlo (default: MC) \cr
  - V: number of runs (default: 10) \cr
  - test_size: percentage of data in the test dataset, for MC
    (irrelevant for V-fold). Default: 0.2. \cr
  - shuffle: wether or not to shuffle data before V-fold.
    Irrelevant for Monte-Carlo; default: TRUE \cr
Default (if NULL): type="MC", V=10, test_size=0.2}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgghooCV-predict"></a>}}
\if{latex}{\out{\hypertarget{method-AgghooCV-predict}{}}}
\subsection{Method \code{predict()}}{
Predict an agghoo model (after calling fit())
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgghooCV$predict(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Matrix or data.frame to predict}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgghooCV-getParams"></a>}}
\if{latex}{\out{\hypertarget{method-AgghooCV-getParams}{}}}
\subsection{Method \code{getParams()}}{
Return the list of V best parameters (after calling fit())
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgghooCV$getParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgghooCV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AgghooCV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgghooCV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
