% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_Model.R
\name{Model}
\alias{Model}
\title{R6 class representing a (generic) model.}
\description{
"Model" class, containing a (generic) learning function, which from
data + target [+ params] returns a prediction function X --> y.
Parameters for cross-validation are either provided or estimated.
Model family can be chosen among "tree", "ppr" and "knn" for now.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{nmodels}}{Number of parameters (= number of [predictive] models)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Model-new}{\code{Model$new()}}
\item \href{#method-Model-get}{\code{Model$get()}}
\item \href{#method-Model-getParam}{\code{Model$getParam()}}
\item \href{#method-Model-clone}{\code{Model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-new"></a>}}
\if{latex}{\out{\hypertarget{method-Model-new}{}}}
\subsection{Method \code{new()}}{
Create a new generic model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$new(data, target, task, gmodel = NULL, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Matrix or data.frame}

\item{\code{target}}{Vector of targets (generally numeric or factor)}

\item{\code{task}}{"regression" or "classification"}

\item{\code{gmodel}}{Generic model returning a predictive function; chosen
automatically given data and target nature if not provided.}

\item{\code{params}}{List of parameters for cross-validation (each defining a model)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-get"></a>}}
\if{latex}{\out{\hypertarget{method-Model-get}{}}}
\subsection{Method \code{get()}}{
Returns the model at index "index", trained on dataHO/targetHO.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get(dataHO, targetHO, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataHO}}{Matrix or data.frame}

\item{\code{targetHO}}{Vector of targets (generally numeric or factor)}

\item{\code{index}}{Index of the model in 1...nmodels}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getParam"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getParam}{}}}
\subsection{Method \code{getParam()}}{
Returns the parameter at index "index".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getParam(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Index of the model in 1...nmodels}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
