% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearWAgg.R
\name{LinearWAgg}
\alias{LinearWAgg}
\title{Aggregation Method: LinearWAgg}
\usage{
LinearWAgg(
  expert_judgements,
  type = "DistLimitWAgg",
  weights = NULL,
  name = NULL,
  placeholder = FALSE,
  percent_toggle = FALSE,
  flag_loarmean = FALSE,
  round_2_filter = TRUE
)
}
\arguments{
\item{expert_judgements}{A dataframe in the format of \link{data_ratings}.}

\item{type}{One of \code{"Judgement"}, \code{"Participant"}, \code{"DistLimitWAgg"}, \code{"GranWAgg"}, or \code{"OutWAgg"}.}

\item{weights}{(Optional) A two column dataframe (\code{user_name} and \code{weight}) for \code{type = "Participant"}
or a three two column dataframe (\verb{paper_id', 'user_name} and \code{weight}) for \code{type = "Judgement"}}

\item{name}{Name for aggregation method. Defaults to \code{type} unless specified.}

\item{placeholder}{Toggle the output of the aggregation method to impute placeholder data.}

\item{percent_toggle}{Change the values to probabilities. Default is \code{FALSE}.}

\item{flag_loarmean}{A toggle to impute log mean (defaults \code{FALSE}).}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}
}
\value{
A tibble of confidence scores \code{cs} for each \code{paper_id}.
}
\description{
Calculate one of several types of linear-weighted best estimates.
}
\details{
This function returns weighted linear combinations of the best-estimate judgements for each claim.

\code{type} may be one of the following:
\loadmathjax

\strong{Judgement}: Weighted by user-supplied weights at the judgement level
\mjdeqn{\hat{p}_c\left( JudgementWeights \right) = \sum_{i=1}^N
\tilde{w}\_judgement_{i,c}B_{i,c}}{ascii}

\strong{Participant}: Weighted by user-supplied weights at the participant level
\mjdeqn{\hat{p}_c\left( ParticipantWeights \right) = \sum_{i=1}^N
\tilde{w}\_participant_{i}B_{i,c}}{ascii}

\strong{DistLimitWAgg}: Weighted by the distance of the best estimate from the
closest certainty limit. Giving greater weight to best estimates that are closer to certainty
limits may be beneficial.
\mjdeqn{w\_distLimit_{i,c} = \max \left(B_{i,c}, 1-B_{i,c}\right)}{ascii}
\mjdeqn{\hat{p}_c\left( DistLimitWAgg \right) = \sum_{i=1}^N
\tilde{w}\_distLimit_{i,c}B_{i,c}}{ascii}

\strong{GranWAgg}: Weighted by the granularity of best estimates

Individuals are weighted by whether or not their best estimates are more
granular than a level of 0.05 (i.e., not a multiple of 0.05).
\mjdeqn{w\_gran_{i} = \frac{1}{C} \sum_{d=1}^C \left\lceil{\frac{B_{i,d}}
{0.05}-\left\lfloor{\frac{B_{i,d}}{0.05}}\right\rfloor}\right\rceil,}{ascii}

where \mjeqn{\lfloor{\ }\rfloor}{ascii} and \mjeqn{\lceil{\ }\rceil}{ascii}
are the mathematical floor and ceiling functions respectively.
\mjdeqn{\hat{p}_c\left( GranWAgg \right) = \sum_{i=1}^N \tilde{w}\_gran_{i}
B_{i,c}}{ascii}

\strong{OutWAgg}: Down weighting outliers

This method down-weights outliers by using the differences from the central
tendency (median) of an individual's best estimates.
\mjdeqn{d_{i,c} = \left(median\{{B_{i,c}}_{_{i=1,...,N}}\} - B_{i,c}\right)^2}{ascii}
\mjdeqn{w\_out_{i} = 1 - \frac{d_{i,c}}{\max({d_c})})}{ascii}
\mjdeqn{\hat{p}_c\left( OutWAgg \right) = \sum_{i=1}^N \tilde{w}\_out_{i}B_{i,c}}{ascii}
}
\examples{
\donttest{LinearWAgg(data_ratings)}

}
