% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-normalization.R
\name{get_opt_results}
\alias{get_opt_results}
\alias{get_opt_results.aghq}
\alias{get_opt_results.marginallaplace}
\title{Obtain the optimization results from an aghq object}
\usage{
get_opt_results(obj, ...)

\method{get_opt_results}{aghq}(obj, ...)

\method{get_opt_results}{marginallaplace}(obj, ...)
}
\arguments{
\item{obj}{Object of class \code{aghq} returned by \code{aghq::aghq}.}

\item{...}{Not used}
}
\value{
A named list with elements:
\itemize{
\item{\code{mode}: a numeric vector of length \code{dim(theta)} containing the posterior mode.}
\item{\code{hessian}: a numeric matrix of dimension \code{dim(theta) x dim(theta)} containing the negative Hessian of the log-posterior evaluated at the mode.}
}
For objects of class \code{marginallaplace}, a third list item \code{modesandhessians} is
a \code{data.frame} containing
the mode and Hessian of the \code{W} parameters evaluated at each adapted quadrature point.
}
\description{
Quick helper S3 method to retrieve the mode and Hessian from an aghq object. The
full results of calling \code{aghq::optimize_theta} are stored in \code{obj$optresults}.
}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{get_hessian}()},
\code{\link{get_log_normconst}()},
\code{\link{get_mode}()},
\code{\link{get_nodesandweights}()},
\code{\link{get_numquadpoints}()},
\code{\link{get_param_dim}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace_tmb}()},
\code{\link{marginal_laplace}()},
\code{\link{nested_quadrature}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{print.marginallaplacesummary}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()},
\code{\link{summary.marginallaplace}()}
}
\concept{quadrature}
