% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-aghq.R
\name{marginal_laplace_tmb}
\alias{marginal_laplace_tmb}
\title{AGHQ-normalized marginal Laplace approximation from a TMB function template}
\usage{
marginal_laplace_tmb(
  ff,
  k,
  startingvalue,
  transformation = default_transformation(),
  optresults = NULL,
  basegrid = NULL,
  control = default_control_tmb(),
  ...
)
}
\arguments{
\item{ff}{The output of calling \code{TMB::MakeADFun()} with \code{random} set
to a non-empty subset of the parameters. \strong{VERY IMPORTANT}: \code{TMB}'s
automatic Laplace approximation requires you to write your template implementing
the \strong{negated} log-posterior. Therefore, this list that you input here
will contain components \code{fn}, \code{gr} and \code{he} that implement the
\strong{negated} log-posterior and its derivatives. This is \strong{opposite}
to every other comparable function in the \code{aghq} package, and is done
here to emphasize compatibility with \code{TMB}.}

\item{k}{Integer, the number of quadrature points to use. I suggest at least 3. k = 1 corresponds to a Laplace
approximation.}

\item{startingvalue}{Value to start the optimization. \code{ff$fn(startingvalue)},
\code{ff$gr(startingvalue)}, and \code{ff$he(startingvalue)} must all return
appropriate values without error.}

\item{transformation}{Optional. Do the quadrature for parameter \code{theta}, but
return summaries and plots for parameter \code{g(theta)}. This applies to the \code{theta}
parameters only, not the \code{W} parameters.
\code{transformation} is either: a) an \code{aghqtrans} object returned by \code{aghq::make_transformation},
or b) a list that will be passed to that function internally. See \code{?aghq::make_transformation} for details.}

\item{optresults}{Optional. A list of the results of the optimization of the log
posterior, formatted according to the output of \code{aghq::optimize_theta}. The
\code{aghq::aghq} function handles the optimization for you; passing this list
overrides this, and is useful for when you know your optimization is too difficult to be
handled by general-purpose software. See the software paper for several examples of this.
If you're unsure whether this option is needed for your problem then it probably is not.}

\item{basegrid}{Optional. Provide an object of class \code{NIGrid} from the \code{mvQuad}
package, representing the base quadrature rule that will be adapted. This is only
for users who want more complete control over the quadrature, and is not necessary
if you are fine with the default option which basically corresponds to
\code{mvQuad::createNIGrid(length(theta),'GHe',k,'product')}. \strong{Note}: the \code{mvQuad}
functions used within \code{aghq} operate on grids in memory, so your \code{basegrid}
object will be changed after you run \code{aghq}.}

\item{control}{A list of control parameters. See \code{?default_control} for details. Valid options are:
\itemize{
\item{\code{method}: }{optimization method to use for the \code{theta} optimization:
\itemize{
\item{'sparse_trust' (default): }{\code{trustOptim::trust.optim}}
\item{'sparse': }{\code{trust::trust}}
\item{'BFGS': }{\code{optim(...,method = "BFGS")}}
}
}
\item{\code{inner_method}: }{optimization method to use for the \code{W} optimization; same
options as for \code{method}. Default \code{inner_method} is 'sparse_trust' and default \code{method} is 'BFGS'.
}
\item \code{negate}: default \code{TRUE}. See \code{?default_control_tmb}. Assumes that your \code{TMB} function
template computes the \strong{negated} log-posterior, which it must if you're using \code{TMB}'s automatic
Laplace approximation, which you must be if you're using this function!}.}

\item{...}{Additional arguments to be passed to \code{ff$fn}, \code{ff$gr}, and \code{ff$he}.}
}
\value{
If \code{k > 1}, an object of class \code{marginallaplace}
(and inheriting from class \code{aghq}) of the same
structure as that returned by \code{aghq::marginal_laplace()}, with \code{plot}
and \code{summary} methods, and suitable for input into \code{aghq::sample_marginal()}
for drawing posterior samples.
}
\description{
Implement the algorithm from \code{aghq::marginal_laplace()}, but making use of
\code{TMB}'s automatic Laplace approximation. This function takes a function
list from \code{TMB::MakeADFun()} with a non-empty set of \code{random} parameters,
in which the \code{fn} and \code{gr} are the unnormalized marginal Laplace
approximation and its gradient. It then calls \code{aghq::aghq()} and formats
the resulting object so that its contents and class match the output of
\code{aghq::marginal_laplace()} and are hence suitable for post-processing
with \code{summary}, \code{aghq::sample_marginal()}, and so on.
}
\details{
Because \code{TMB} does not yet have the Hessian of the log marginal Laplace
approximation implemented, a numerically-differentiated jacobian of the gradient
is used via \code{numDeriv::jacobian()}. You can turn this off (using \code{ff$he()} instead,
which you'll have to modify yourself) using \code{default_control_tmb(numhessian = FALSE)}.
}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{get_hessian}()},
\code{\link{get_log_normconst}()},
\code{\link{get_mode}()},
\code{\link{get_nodesandweights}()},
\code{\link{get_numquadpoints}()},
\code{\link{get_opt_results}()},
\code{\link{get_param_dim}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace}()},
\code{\link{nested_quadrature}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{print.marginallaplacesummary}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()},
\code{\link{summary.marginallaplace}()}
}
\concept{quadrature}
