% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thtap2thta.R
\name{thtap2thta}
\alias{thtap2thta}
\title{Obtain theta from pooled theta (model without treatment).}
\usage{
thtap2thta(bta1, thtap, ar = 0.5, thtawarning = FALSE)
}
\arguments{
\item{bta1}{log-transform of assumed rate ratio.}

\item{thtap}{Estimate of the variance of the frailty parameter under misspecification (no adjustment for treatment).}

\item{ar}{Allocation ratio (Number in control / Total).}

\item{thtawarning}{If TRUE indicates how many estimates of theta were negative before setting to 0. Default FALSE.}
}
\value{
An estimate of the variance of the frailty parameter when the model includes treatment.
}
\description{
Function transforms estimate of blinded pooled theta (from misspecified model without adjusting for treatment) to estimate of theta for model adjusting for treatment.
}
\details{
This function assumes a recurrent event distribution with exponential baseline function and frailty parameter distribution with mean 1 and variance \eqn{\theta},
and derives from expectations of the variance under misspecification.

Specifically, the following relationship between the frailty variance for the misspecified model (\eqn{\theta_p}) and correctly specified model (\eqn{\theta}) is used
\deqn{\theta_p = Var(Z \cdot \exp{\beta}) = c^2 - 2pc - 2(1-p)\exp{\beta}c + (p + (1-p)\exp{2\beta})(\theta + 1)},
where \eqn{c = E(Z\exp{X\beta})} and \eqn{p = ar}.
}
\examples{

thtap2thta(2, log(c(0.8, 0.7, 0.6)))

}
