% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.linbin.R
\name{stability.linbin}
\alias{stability.linbin}
\title{Superiority measure}
\usage{
stability.linbin(dataf, res_var, gen_var, env_var, rep_var,
  plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
A numeric vector with superiority measure Pi of genotypes.
}
\description{
This function calculates the Lin&Binn's superiority measure.
}
\examples{
data(exp_data)
stability.linbin(exp_data,"yield","gen","env","rep")
}
\references{
Lin, C.S. and M.R. Binns. 1988. A superiority measure of cultivar performance for cultivar x location data. Can J Plant Sci 68: 193?198. doi: 10.4141/cjps88-018
}
