% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_agvgdweb.R
\name{read_agvgdweb_results}
\alias{read_agvgdweb_results}
\title{Read in AGVGD Web Results}
\usage{
read_agvgdweb_results(file = stop("`file` is missing"), alignment = NULL)
}
\arguments{
\item{file}{A file path to the results output by the AGVGD Web app.}

\item{alignment}{A character matrix or an alignment object obtained with
\code{\link[=read_alignment]{read_alignment()}}. Rows are expected to be sequences of single characters
(protein residues), and columns the alignment positions. The first row must
be the reference sequence, i.e. the sequence whose substitutions will be
evaluated against. This parameter can be left \code{NULL}. If supplied the
column \code{poi} in the output will be filled in (default is to be \code{NA}).}
}
\value{
A \link[tibble:tibble-package]{tibble} of seven columns:
\describe{
\item{res}{Position of the amino acid residue in the reference protein
(first sequence in the alignment). This position corresponds to \code{poi} minus
the gaps in the alignment.}
\item{poi}{Position of interest, i.e. the alignment position at which the
amino acid substitution is being assessed. Because this information is not
provided by AGVGD Web app this column is always \code{NA}; we keep it though for
coherence with the output of \code{agvgd()}.}
\item{ref}{Reference amino acid, i.e. the amino acid in the first sequence
of the alignment, at the position of interest.}
\item{sub}{Amino acid substitution being assessed.}
\item{gv}{Grantham variation score.}
\item{gd}{Grantham difference score.}
\item{prediction}{Predicted effect of the amino acid substitution. This is
classed as C0, C15, C25, C35, C45, C55, or C65, with C65 most likely to
interfere with function and C0 least likely.}
}
}
\description{
This function imports into R the results generated by the AGVGD Web
application \url{http://agvgd.hci.utah.edu/}.
}
\keyword{internal}
