% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snc.R
\name{snc}
\alias{snc}
\title{Fit a model to discovery records}
\usage{
snc(
  y,
  mu = NULL,
  pi = NULL,
  data = NULL,
  init = NULL,
  growth = TRUE,
  type = "exponential",
  ...
)
}
\arguments{
\item{y}{either a vector describing the number of discovered alien and invasive species (IAS) over a given time period, or the name (quoted or unquoted) of the corresponding column in the provided data.}

\item{mu}{a formula defining the predictors for \eqn{\mu_t}, the annual introduction rate. Formulas should be provided in the syntax \code{~ x1 + x2 + ... + xn}. Use \code{~ 1} for an intercept only model.}

\item{pi}{a formula defining the predictors for \eqn{\Pi_{st}}, the annual probability of detection. Formulas should be provided in the syntax \code{~ x1 + x2 + ... + xn}. Use \code{~ 1} for an intercept only model.}

\item{data}{a data frame containing the variables in the model(s).}

\item{init}{Optional. Initial values supplied to \code{optim}. Must be same length as the total number of parameters.}

\item{growth}{logical. Should the population growth parameter \eqn{\gamma_2} be included in the model for \eqn{\Pi_{st}}?. Note that values for \code{init}, if provided, need to include an initial value for the growth parameter, when \code{growth = TRUE}.}

\item{type}{Define whether the mu function should be on "linear" or "exponential" scale. Defaults to "exponential".}

\item{...}{Further arguments passed to \code{optim}.}
}
\value{
\code{snc} returns an object of class "snc" containing: \tabular{ll}{
\code{records} \tab the supplied first records data \cr
\code{convergence} \tab the \code{optim} convergence code.\cr
\code{log-likelihood} \tab the maximum log-likelihood.\cr
\code{coefficients} \tab a named vector of the ML estimates of the   coefficients.\cr
\code{fitted.values} \tab the fitted mean \eqn{\lambda} values.\cr
\code{predict} \tab a data frame containing the estimated mean +- Standard error \eqn{\mu} values.\cr
}
}
\description{
Fit a model to a time series describing first records of alien species.
If no external data is provided, the function fits the model described in Solow and Costello (2004).
When external data on either \eqn{\mu_t} or \eqn{\Pi_{st}} is provided, the function fits the
modified model (sampling-proxy model in the case of \eqn{\Pi_{st}}) as described in Buba et al (2024).
}
\details{
This function expands on the model described in Solow and Costello (2004) by facilitating the
inclusion of external data to describe either introduction rate \eqn{\mu_t} or detection probability \eqn{\Pi_{st}}.
The model with external data for detection probability (sampling-proxy model) is described fully in Buba et al (2024).
The use of external data to describe the introduction rate has not been thoroughly evaluated.
When no formula is defined for either, the function automatically fits the original Solow and Costello (2004)
model using the length of the vector data as the independent variable \eqn{t}.
All models return estimated parameters for both the introduction rate and the detection probability,
with the parameter of interest usually being the change of introduction rate - \eqn{\beta_1}.
For more details see the Basic Usage vignette:
\code{vignette("basic_usage", package = "alien")}
}
\examples{
\donttest{
# Solow and Costello (2004) model:
data(sfestuary)
example_model <- snc(sfestuary)
print(example_model)

# Buba et al (2024) sampling-proxy model:
data(medfish)
example_buba <- snc(y = aliens, pi = ~ natives, data = medfish)
print(example_buba)
}
}
\references{
Solow, A. R., & Costello, C. J. (2004). Estimating the rate of species introductions from the discovery record. Ecology, 85(7), 1822–1825. https://doi.org/10.1890/03-3102

Buba, Y., Kiflwai, M., McGeoch, M. A., Belmaker, J. (2024) Evaluating models for estimating introduction rates of alien species from discovery records. https://doi.org/10.1111/geb.13859
}
