% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_linear}
\alias{baseline_linear}
\alias{baseline_linear-method}
\alias{baseline_linear,numeric,numeric-method}
\alias{baseline_linear,ANY,missing-method}
\title{Linear Baseline Estimation}
\usage{
baseline_linear(x, y, ...)

\S4method{baseline_linear}{numeric,numeric}(x, y, points = range(x))

\S4method{baseline_linear}{ANY,missing}(x, points = range(x))
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{points}{A \code{\link{numeric}} vector specifying the data points to be used in
the fitting process (in \code{x} unit).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Linear Baseline Estimation
}
\examples{
## X-ray diffraction
data("XRD")

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Linear baseline
baseline <- baseline_linear(XRD, points = c(25, 34))

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(baseline, type = "l", col = "red")

## Correct baseline
XRD$count <- XRD$count - baseline$y

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_asls}()},
\code{\link{baseline_peakfilling}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_rubberband}()},
\code{\link{baseline_snip}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
