% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/windows.R
\docType{methods}
\name{window_tumbling}
\alias{window_tumbling}
\alias{window_tumbling-method}
\alias{window_tumbling,integer,integer-method}
\alias{window_tumbling,numeric,numeric-method}
\title{Tumbling Windows}
\usage{
window_tumbling(n, m, ...)

\S4method{window_tumbling}{integer,integer}(n, m, drop = FALSE)

\S4method{window_tumbling}{numeric,numeric}(n, m, drop = FALSE)
}
\arguments{
\item{n}{An \code{\link{integer}} giving the length of the data series (will be coerced
with \code{\link[=as.integer]{as.integer()}} and hence truncated toward zero).}

\item{m}{An \code{\link{integer}} giving the window size, i.e. the number of
adjacent points to be used (will be coerced with \code{\link[=as.integer]{as.integer()}} and hence
truncated toward zero).}

\item{...}{Currently not used.}

\item{drop}{A \code{\link{logical}} scalar: if \code{m} is not a multiple of \code{n}, should the
last data points be removed so that all windows have the same length?}
}
\value{
Returns a \code{\link{list}} of \code{\link{integer}} vectors (indices of the data points in
each window).
}
\description{
Tumbling Windows
}
\examples{
## Length of the data series
n <- 10

## Progressive sliding windows
sliding <- window_sliding(n = n, m = 5)

plot(NULL, xlim = c(1, n), ylim = c(1, 10.5), xlab = "Index", ylab = "Window")
for (i in seq_along(sliding)) {
  w <- sliding[[i]]
  text(x = w, y = rep(i, length(w)), labels = w, pos = 3)
  lines(w, rep(i, length(w)), type = "l", lwd = 2)
}

## Tumbling windows
## (compare with drop = TRUE)
tumbling <- window_tumbling(n = n, m = 3, drop = FALSE)

plot(NULL, xlim = c(1, n), ylim = c(1, 5.5), xlab = "Index", ylab = "Window")
for (i in seq_along(tumbling)) {
  w <- tumbling[[i]]
  text(x = w, y = rep(i, length(w)), labels = w, pos = 3)
  lines(w, rep(i, length(w)), type = "l", lwd = 2)
}

}
\seealso{
Other moving windows: 
\code{\link{window_sliding}()}
}
\author{
N. Frerebeau
}
\concept{moving windows}
