% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_tmc_format.R
\name{convert_tmc_format}
\alias{convert_tmc_format}
\title{Get standard data structure}
\usage{
convert_tmc_format(
  inputpath_to_excelfolder,
  exportpath_to_csvfolder,
  daily_mp_dose = 60,
  weekly_mtx_dose = 20
)
}
\arguments{
\item{inputpath_to_excelfolder}{Path to folder containing input excel files (in quotes)}

\item{exportpath_to_csvfolder}{Path to folder in which to save final output csv files (in quotes)}

\item{daily_mp_dose}{numeric value of DAILY 6-Mercaptopurine dose per \eqn{1m^{2}} (\eqn{mg/m^{2}}) as per the MT dosing protocol.
Default = \eqn{60mg/m^{2}} (as per ICiCLe-ALL-14 protocol)}

\item{weekly_mtx_dose}{numeric value of WEEKLY absolute Methotrexate dose per \eqn{1m^{2}} (\eqn{mg/m^{2}}) as per the MT dosing protocol.
Default = \eqn{20mg/m^{2}} (as per ICiCLe-ALL-14 protocol)}
}
\value{
Folder with converted csv files
}
\description{
Convert a Tata Medical Center Kolkata India (TMC) based excel workbook into a standard format for analysis

Convert a maintenance therapy excel workbook (with individual sheets per cycle) into a single csv file
with longitudinal data of blood count parameters, absolute doses and dose intensities of administered drugs.
}
\examples{
\donttest{
# As per ICiCLe-ALL-14 protocol (Reference PMID - 35101099):
path_to_excel = paste0(system.file("extdata/tmc_data/", package = "allMT"), "/")
save_path = paste0(tempdir(),"/")
convert_tmc_format(inputpath_to_excelfolder = path_to_excel,
                   exportpath_to_csvfolder = save_path,
                   daily_mp_dose = 60,
                   weekly_mtx_dose = 20)


# As per ICiCLe-ALL-14 protocol (Reference PMID - 35101099):
convert_tmc_format(inputpath_to_excelfolder = path_to_excel,
                   exportpath_to_csvfolder = save_path)

# As per BFM protocol (Reference PMID - 15902295):
convert_tmc_format(inputpath_to_excelfolder = path_to_excel,
                   exportpath_to_csvfolder = save_path,
                   daily_mp_dose = 50,
                   weekly_mtx_dose = 20)

# As per St Jude protocol (Reference PMID - 15902295):
convert_tmc_format(inputpath_to_excelfolder = path_to_excel,
                   exportpath_to_csvfolder = save_path,
                   daily_mp_dose = 75,
                   weekly_mtx_dose = 40)
}
}
\seealso{
\code{\link[=convert_external_format]{convert_external_format()}}
}
