% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_progression.R
\name{plot_progression}
\alias{plot_progression}
\title{Graphical representation of maintenance therapy data for single patient}
\usage{
plot_progression(input_file_path, anc_range, unit)
}
\arguments{
\item{input_file_path}{Path to input csv file for the patient (in quotes)}

\item{anc_range}{ANC target range as per the protocol: (c(lower threshold, upper threshold)). NOTE: Ensure that units are the same as unit of ANC in the input data.}

\item{unit}{Choose either "million" or "billion".
\itemize{
\item{"million" = million cells/L (x\eqn{10^{6}} cells/L or cells/\eqn{\mu}l)}
\item{"billion" = billion cells/L (x\eqn{10^{9}} cells/L or x\eqn{10^{3}} cells/\eqn{\mu}l)}
}}
}
\value{
plot image
}
\description{
Creates a line graph (trends) for absolute neutrophil count (ANC), 6-Mercaptopurine (6MP) and Methotrexate (MTX) doses across all visits for the given patient
}
\note{
\itemize{
\item{If there is only one threshold for anc_range parameter, please specify the respective value and keep the other threshold as NA. eg : c(2000, NA)}
\item{Horizontal dotted lines on the graph indicate anc_range thresholds and starting doses for 6MP and MTX as a reference (colour coded to corresponding parameter)}
}
}
\examples{
pat_data = system.file("extdata/processed_data/", "UPN_915.csv", package = "allMT")
plot_progression(input_file_path = pat_data, anc_range = c(0.75,1.5), unit = "billion")

\donttest{
# As per BFM protocol (Reference PMID - 15902295):
plot_progression(input_file_path = "../UPN1.csv", anc_range = c(2, NA), unit = "billion")

# As per St Jude protocol (Reference PMID - 15902295):
plot_progression(input_file_path = "../../UPN1.csv", anc_range = c(0.3, 1), unit = "billion")
}

}
\seealso{
\code{\link[=summarize_cycle_progression]{summarize_cycle_progression()}}
}
