% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alma-events.R
\name{alma_events}
\alias{alma_events}
\title{Get all events}
\usage{
alma_events(rschedule, ..., year = NULL)
}
\arguments{
\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule, runion, rintersect, or rsetdiff.}

\item{...}{These dots are for future extensions and must be empty.}

\item{year}{\verb{[NULL / integer]}

An optional integer vector of years to limit the returned events to.}
}
\value{
A Date vector of events.
}
\description{
\code{alma_events()} retrieves all of the events in the rschedule's
event set.
}
\examples{
rrule <- daily(since = "1970-01-01", until = "1970-01-05")

alma_events(rrule)

on_christmas <- yearly() \%>\%
  recur_on_month_of_year("Dec") \%>\%
  recur_on_day_of_month(25)

alma_events(on_christmas, year = c(2020, 2022))
}
