% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcalendar.R
\name{calendar-add-remove}
\alias{calendar-add-remove}
\alias{cal_add}
\alias{cal_remove}
\title{Calendar additions and removals}
\usage{
cal_add(x, rholiday)

cal_remove(x, what)
}
\arguments{
\item{x}{\verb{[rcalendar]}

An rcalendar.}

\item{rholiday}{\verb{[rholiday]}

An rholiday to add to the rcalendar.}

\item{what}{\verb{[character(1) / rholiday]}

The name of a holiday to remove from the rcalendar, or an rholiday object
with the corresponding name that you'd like to remove.}
}
\value{
A new rcalendar with the holiday added or removed.
}
\description{
\itemize{
\item \code{cal_add()} adds an rholiday to an rcalendar.
\item \code{cal_remove()} removes an rholiday from an rcalendar by name, either by
specifying a character name or an rholiday object with the same name.
}
}
\examples{
cal <- rcalendar(
  hol_christmas(),
  hol_halloween(),
  hol_new_years_day(),
  hol_us_presidents_day()
)

# Can't forget Easter!
cal \%>\%
  cal_add(hol_easter())

# Didn't actually need Halloween
cal \%>\%
  cal_remove(hol_halloween())

# Can remove by name or by object
cal \%>\%
  cal_remove("Halloween")
}
