% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcalendar.R
\name{calendar-locations}
\alias{calendar-locations}
\alias{cal_next}
\alias{cal_previous}
\title{Calendar locations}
\usage{
cal_next(x, rcalendar, ..., inclusive = FALSE)

cal_previous(x, rcalendar, ..., inclusive = FALSE)
}
\arguments{
\item{x}{\verb{[Date]}

A vector of dates.}

\item{rcalendar}{\verb{[rcalendar]}

An rcalendar.}

\item{...}{These dots are for future extensions and must be empty.}

\item{inclusive}{\verb{[logical(1)]}

If \code{x} is an event, should it be considered the next or previous event?}
}
\value{
A two column data frame, like \code{cal_events()}, which is the same size as \code{x}
and contains either the next or previous holiday relative to \code{x}.
}
\description{
\itemize{
\item \code{cal_next()} generates the next holiday after \code{x}.
\item \code{cal_previous()} generates the previous holiday before \code{x}.
}

If no holiday exists before/after \code{x}, a missing row is generated.
}
\examples{
x <- as.Date(c("2023-04-11", "2023-08-10", "2021-05-06"))
cal <- cal_us_federal()

cal_next(x, cal)
cal_previous(x, cal)
}
