% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rholiday.R
\name{rholiday}
\alias{rholiday}
\title{Create a recurring holiday}
\usage{
rholiday(rschedule, name)
}
\arguments{
\item{rschedule}{\verb{[rschedule]}

The recurrence schedule that determines when the holiday occurs.}

\item{name}{\verb{[character(1)]}

The name of the holiday. This serves as a unique identifier when adding
multiple holidays to an \code{\link[=rcalendar]{rcalendar()}}.}
}
\description{
\code{rholiday()} is used to create custom holidays. It wraps up a holiday \code{name}
and its corresponding \code{rschedule} into a holiday object with special
properties.

Holiday objects can be tweaked with \code{\link[=hol_rename]{hol_rename()}}, \code{\link[=hol_observe]{hol_observe()}}, and
\code{\link[=hol_offset]{hol_offset()}}, and they can be added to a calendar with \code{\link[=rcalendar]{rcalendar()}}.
}
\examples{
on_christmas <- yearly() \%>\%
  recur_on_month_of_year("Dec") \%>\%
  recur_on_day_of_month(25)

# Bundle a holiday name with its recurrence schedule to create a holiday
rholiday(on_christmas, "Christmas")

# This is how the built in holiday objects are created
hol_christmas()
}
