% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altfuel_api.R
\name{nearest_stations}
\alias{nearest_stations}
\title{Retrieve Nearest Alternate Fuel Stations by Criteria}
\usage{
nearest_stations(
  api_key,
  location = NULL,
  latitude = NULL,
  longitude = NULL,
  radius = NULL,
  params = nrel_params(radius = "infinite")
)
}
\arguments{
\item{api_key}{Character. An authorized API key for the NREL API service. API keys can be requested at \url{https://developer.nrel.gov/signup/}}

\item{location}{A free-form input describing the address of the location. This may include the address given in a variety of formats, such as: street, city, state, postal code, etc.}

\item{latitude}{Numeric. The latitude of the desired location.}

\item{longitude}{Numeric. The longitude of the desired location.}

\item{radius}{Numeric. The radius (in miles) around the search location to search for stations within. An explicit radius of up to 500.0 miles may be passed in, or the special infinite string may be passed in to find the nearest stations regardless of distance. Defaults to 'infinite'.}

\item{params}{A list of parameters for the API call. See ?nrel_params for options.}
}
\value{
An object of class nrel_api, containing content, parameters, and response.
}
\description{
Location parameters can either be passed directly as arguments, or imported using the \code{nrel_params()} function to generate a list. Location passed as arguments takes precedence.
}
\examples{
\dontrun{
# find the 5 nearest Tesla stations to FAA HQ in Washington DC
my_params <- nrel_params(fuel_type = "ELEC", ev_connector_type = "TESLA", limit = 5)
my_loc <- c("FAA Headquarters, Washington, DC")
tesla_stns <- nearest_stations(MY_API_KEY, location = my_loc, params = my_params)
stations(tesla_stns)
}
}
