% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.forms.R
\name{amber.form_revision}
\alias{amber.form_revision}
\title{Get a form revision}
\usage{
amber.form_revision(amber, form, revision, study = NULL)
}
\arguments{
\item{amber}{An Amber object}

\item{form}{Form's name or identifier}

\item{revision}{Revision number}

\item{study}{Study identifier (name or id), optional.}
}
\value{
A form revision object as a named list
}
\description{
Get a form revision by its form name or identifier and its revision number.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.form_revision(a, form = "Adult trauma", revision = 10)
amber.form_revision(a, form = "61e69a22fea2df2f3108b508", revision = 10)
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.interviews_step_actions}()},
\code{\link{amber.interviews_step_data}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
