% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.interview_export}
\alias{amber.interview_export}
\title{Export the interview records}
\usage{
amber.interview_export(
  amber,
  study = NULL,
  interviewDesign = NULL,
  campaign = NULL,
  from = NULL,
  to = NULL,
  completed = NULL,
  code = NULL,
  identifier = NULL,
  state = NULL,
  participantValid = NULL,
  query = list(),
  skip = 0,
  limit = 100,
  df = TRUE
)
}
\arguments{
\item{amber}{An Amber object}

\item{study}{Study identifier (name or id), optional.}

\item{interviewDesign}{Interview design identifier (name or id), optional.}

\item{campaign}{Campaign identifier (name or id), optional.}

\item{from}{From date (included), optional}

\item{to}{To date (included), optional}

\item{completed}{When TRUE export data from completed interviews only (default is NULL)}

\item{code}{Participant interview code}

\item{identifier}{Patient/participant study identifier}

\item{state}{State of the interview: 'initiated', 'in_progress', 'completed'}

\item{participantValid}{Participant is valid (logical): active and in the valid date range}

\item{query}{The search query}

\item{skip}{Number of items to skip}

\item{limit}{Max number of items}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
A named list of data.frames, a data dictionary and a data data.frame
per form revision (or a named list of raw results when 'df' is FALSE)
}
\description{
Export the interview records (data and dictionary) of interview step(s).
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")

# Extract data from all interviews
amber.interview_export(a)

# Extract data from all completed interviews
amber.interview_export(a, completed = TRUE)

# Extract data from all interviews in a range of time
amber.interview_export(a, from = "2022-01-12 00:00", to = "2022-02-13")

# Extract data from all interviews for a specific participant/patient
# study identifier
amber.interview_export(a, identifier = "1231")

# Extract data from all interviews having their participant study
# identifier matching a regular expression
amber.interview_export(a, query = list(`identifier[$search]` = "^12"))

# Extract data from all interviews having their participant attributes
# matching a value
# (will not work if the data are encrypted in the database)
amber.interview_export(a, query = list(data.country = "fr"))

# Export records collected with a study's interview design
tables <- amber.interview_export(a,
  study = "liftup",
  interviewDesign = "treocapa_lt")

# Result contains both data and dictionary
tables

# Tables are named with the <interview design name>-<form name>-<revision> pattern
names(tables)

# Merge datasets from different versions if relevant
dplyr::bind_rows(lapply(tables, function (t) {
  t$data
}))

amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interviews}()},
\code{\link{amber.interviews_step_actions}()},
\code{\link{amber.interviews_step_data}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
