% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.interviews}
\alias{amber.interviews}
\title{Get the interview records}
\usage{
amber.interviews(
  amber,
  study = NULL,
  interviewDesign = NULL,
  campaign = NULL,
  from = NULL,
  to = NULL,
  code = NULL,
  identifier = NULL,
  state = NULL,
  participantValid = NULL,
  query = list(),
  skip = 0,
  limit = 100,
  mergeUpdatedFillingDates = FALSE,
  df = TRUE
)
}
\arguments{
\item{amber}{An Amber object}

\item{study}{Study identifier (name or id), optional.}

\item{interviewDesign}{Interview design identifier (name or id), optional.}

\item{campaign}{Campaign identifier (name or id), optional.}

\item{from}{From date (included), optional}

\item{to}{To date (included), optional}

\item{code}{Participant interview code, optional}

\item{identifier}{Participant identifier, optional}

\item{state}{State of the interview: 'initiated', 'in_progress', 'completed'}

\item{participantValid}{Participant is valid (logical): active and in the valid date range}

\item{query}{A search query}

\item{skip}{Number of items to skip}

\item{limit}{Max number of items}

\item{mergeUpdatedFillingDates}{Set the last update date as being the filling date, if filling date is empty (default is FALSE).}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
A data.frame (or a named list of raw results when 'df' is FALSE)
}
\description{
Get the interviews of one or several interview design(s).
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")

# Find all interviews
amber.interviews(a)

# Find all interviews in a range of time
amber.interviews(a, from = "2022-01-12 00:00", to = "2022-02-13")

# Find all interviews for a specific participant/patient study identifier
amber.interviews(a, identifier = "1231")

# Find all interviews having their identifier matching a regular expression
amber.interviews(a, query = list(`data._id[$search]` = "^12"))

# Find all interviews which form data is equal to some value
# (will not work if the data are encrypted in the database)
amber.interviews(a, query = list(data.PATIENT.ORIGIN_REGION = "xyz"))

# Find interview records of a study
amber.interviews(a, study = "Trauma Registry")

amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews_step_actions}()},
\code{\link{amber.interviews_step_data}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
