% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{LebA_slice_ratio_est_acfbased}
\alias{LebA_slice_ratio_est_acfbased}
\title{Nonparametric estimation of the ratios
Leb(A intersection A_h)/Leb(A), Leb(A setdifference A_h)/Leb(A)}
\usage{
LebA_slice_ratio_est_acfbased(data, Delta, h)
}
\arguments{
\item{data}{Data to be used in the trawl function estimation.}

\item{Delta}{Width of the grid on which we observe the data}

\item{h}{Time point used in A intersection A_h and the setdifference
A setdifference A_h}
}
\value{
LebAintersection_ratio: LebAintersection/LebA

LebAsetdifference_ratio: LebAsetdifference/LebA
}
\description{
This function estimates the ratios
Leb(A intersection A_h)/Leb(A), Leb(A\ A_h)/Leb(A).
}
\details{
Estimation of the trawl function using the methodology proposed in
Sauri and Veraart (2022) which is based on the empirical acf.
}
\examples{
\donttest{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 5000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(1726)
#Simulate the trawl process
Poi_data<-ambit::sim_weighted_trawl(my_n, my_delta, "Exp", my_lambda, "Poi", my_v)$path

#Estimate the trawl set and its two slices at time h=0.5
est <- LebA_slice_ratio_est_acfbased(Poi_data, my_delta, h=0.5)
#Print the ratio LebAintersection/LebA
est$LebAintersection_ratio
#Print the ratio LebAsetdifference/LebA
est$LebAsetdifference_ratio
}
}
