% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{test_asymnorm_est}
\alias{test_asymnorm_est}
\title{Computing the feasible statistic of the trawl function CLT}
\usage{
test_asymnorm_est(
  data,
  Delta,
  trawlfct,
  trawlfct_par,
  biascor = FALSE,
  k = NULL
)
}
\arguments{
\item{data}{The data set based on observations of
\eqn{X_0, X_{\Delta_n}, \ldots, X_{(n-1)\Delta_n}}}

\item{Delta}{The width Delta of the observation grid}

\item{trawlfct}{The trawl function for which the
asymptotic variance will be computed (Exp, supIG or LM)}

\item{trawlfct_par}{The parameter vector of the trawl function
(Exp: lambda, supIG: delta, gamma, LM: alpha, H)}

\item{biascor}{A binary variable determining whether a bias correction should
be computed, the default is FALSE}

\item{k}{The optional parameter specifying the time point in
\eqn{0, 1, \ldots, n-1};
the test statistic will be computed for the time point \eqn{k \Delta_n}.}
}
\value{
The function returns the vector of the feasible statistics
\eqn{(T(0)_n, T((\Delta)_n, \ldots, T((n-2)\Delta_n))} if no bias correction
is required and \eqn{(T(0)_n, T((\Delta)_n, \ldots, T((n-3)\Delta_n))} if
bias correction is required if k is not provided, otherwise it returns the
value \eqn{T(k \Delta_n)_n}. If the estimated asymptotic variance is <= 0,
the value of the test statistic is set to 999.
}
\description{
This function computes the feasible statistics associated with the
CLT for the trawl function estimation.
}
\details{
As derived in
Sauri and Veraart (2022), the feasible statistic, for \eqn{t>0},  is given by
\deqn{T(t)_n:=\frac{\sqrt{n\Delta_{n}}}{\sqrt{\widehat{\sigma_{a}^2(t)}}}
\left(\hat{a}(t)-a(t)-bias(t)\right).}
For \eqn{t=0}, we have \deqn{T(t)_n:=\frac{\sqrt{n\Delta_{n}}}{\sqrt{RQ_n}}
\left(\hat{a}(0)-a(0)-bias(0)\right),} where
\deqn{RQ_n:=\frac{1}{\sqrt{2 n\Delta_{n}}}
\sum_{k=0}^{n-2}(X_{(k+1)\Delta_n}-X_{k\Delta_n})^4.}
We set \eqn{bias(t)=0} in the case
when biascor==FALSE and \eqn{bias(t)=0.5 * \Delta * \hat a'(t)} otherwise.
}
\examples{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 1000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(123)
#Simulate the trawl process
Poi_data <- sim_weighted_trawl(my_n, my_delta,
                               "Exp", my_lambda, "Poi", my_v)$path

#Compute the test statistic for time t=0
##Either one can use:
test_asymnorm_est(Poi_data, my_delta,
                  trawlfct="Exp", trawlfct_par=my_lambda)[1]
#or:
test_asymnorm_est(Poi_data, my_delta,
                  trawlfct="Exp", trawlfct_par=my_lambda, k=0)
}
