% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explainer.R
\name{explainer.factor}
\alias{explainer.factor}
\title{Explain method for factor data types}
\usage{
\method{explainer}{factor}(X, xname = NULL, ...)
}
\arguments{
\item{X}{a numeric (or integer) data type}

\item{xname}{a placeholder for variable name}

\item{...}{other parameters required}
}
\value{
Prints the following information on console:
\itemize{
 \item vector name
 \item type
 \item number of distinct values
 \item number of missing values
 \item a frequency table and histogram. If counts of all the factor levels are
 less than half of length of \code{X}, then the histogram is scaled with
 maximum of 50%. (look at \code{?freqTable} for how to read this)
}
}
\description{
This is a \code{explainer} method for factor vector.
}
\details{
This method removes all the missing values in \code{x} before computing the
summaries. This calls the method \code{explainer.character}
}
\examples{
alphabets <- as.factor(sample(LETTERS[1:5], 50, replace = TRUE))
explainer(alphabets)
rm(alphabets)

}
